@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cloudwatchLogsRoleArn Amazon Resource Name of the service role that AWS AppSync will assume to publish to Amazon CloudWatch logs in your account.
 * @property excludeVerboseContent Set to TRUE to exclude sections that contain information such as headers, context, and evaluated mapping templates, regardless of logging  level. Valid values: `true`, `false`. Default value: `false`
 * @property fieldLogLevel Field logging level. Valid values: `ALL`, `ERROR`, `NONE`.
 */
public data class GraphQLApiLogConfig(
    public val cloudwatchLogsRoleArn: String,
    public val excludeVerboseContent: Boolean? = null,
    public val fieldLogLevel: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiLogConfig): GraphQLApiLogConfig = GraphQLApiLogConfig(
            cloudwatchLogsRoleArn = javaType.cloudwatchLogsRoleArn(),
            excludeVerboseContent = javaType.excludeVerboseContent().map({ args0 -> args0 }).orElse(null),
            fieldLogLevel = javaType.fieldLogLevel(),
        )
    }
}
