@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property appIdClientRegex Regular expression for validating the incoming Amazon Cognito User Pool app client ID.
 * @property awsRegion AWS region in which the user pool was created.
 * @property defaultAction Action that you want your GraphQL API to take when a request that uses Amazon Cognito User Pool authentication doesn't match the Amazon Cognito User Pool configuration. Valid: `ALLOW` and `DENY`
 * @property userPoolId User pool ID.
 */
public data class GraphQLApiUserPoolConfig(
    public val appIdClientRegex: String? = null,
    public val awsRegion: String? = null,
    public val defaultAction: String,
    public val userPoolId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.GraphQLApiUserPoolConfig): GraphQLApiUserPoolConfig = GraphQLApiUserPoolConfig(
            appIdClientRegex = javaType.appIdClientRegex().map({ args0 -> args0 }).orElse(null),
            awsRegion = javaType.awsRegion().map({ args0 -> args0 }).orElse(null),
            defaultAction = javaType.defaultAction(),
            userPoolId = javaType.userPoolId(),
        )
    }
}
