@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property cachingKeys The caching keys for a resolver that has caching activated. Valid values are entries from the $context.arguments, $context.source, and $context.identity maps.
 * @property ttl The TTL in seconds for a resolver that has caching activated. Valid values are between `1` and `3600` seconds.
 */
public data class ResolverCachingConfig(
    public val cachingKeys: List<String>? = null,
    public val ttl: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.ResolverCachingConfig): ResolverCachingConfig = ResolverCachingConfig(
            cachingKeys = javaType.cachingKeys().map({ args0 -> args0 }),
            ttl = javaType.ttl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
