@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appsync.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property conflictDetection Conflict Detection strategy to use. Valid values are `NONE` and `VERSION`.
 * @property conflictHandler Conflict Resolution strategy to perform in the event of a conflict. Valid values are `NONE`, `OPTIMISTIC_CONCURRENCY`, `AUTOMERGE`, and `LAMBDA`.
 * @property lambdaConflictHandlerConfig Lambda Conflict Handler Config when configuring `LAMBDA` as the Conflict Handler. See Lambda Conflict Handler Config.
 */
public data class ResolverSyncConfig(
    public val conflictDetection: String? = null,
    public val conflictHandler: String? = null,
    public val lambdaConflictHandlerConfig: ResolverSyncConfigLambdaConflictHandlerConfig? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appsync.outputs.ResolverSyncConfig): ResolverSyncConfig = ResolverSyncConfig(
            conflictDetection = javaType.conflictDetection().map({ args0 -> args0 }).orElse(null),
            conflictHandler = javaType.conflictHandler().map({ args0 -> args0 }).orElse(null),
            lambdaConflictHandlerConfig = javaType.lambdaConflictHandlerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appsync.kotlin.outputs.ResolverSyncConfigLambdaConflictHandlerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
