@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.DataCatalogArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Athena data catalog.
 * More information about Athena and Athena data catalogs can be found in the [Athena User Guide](https://docs.aws.amazon.com/athena/latest/ug/what-is.html).
 * > **Tip:** for a more detailed explanation on the usage of `parameters`, see the [DataCatalog API documentation](https://docs.aws.amazon.com/athena/latest/APIReference/API_DataCatalog.html)
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.athena.DataCatalog("example", {
 *     name: "athena-data-catalog",
 *     description: "Example Athena data catalog",
 *     type: "LAMBDA",
 *     parameters: {
 *         "function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function",
 *     },
 *     tags: {
 *         Name: "example-athena-data-catalog",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.athena.DataCatalog("example",
 *     name="athena-data-catalog",
 *     description="Example Athena data catalog",
 *     type="LAMBDA",
 *     parameters={
 *         "function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function",
 *     },
 *     tags={
 *         "Name": "example-athena-data-catalog",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Athena.DataCatalog("example", new()
 *     {
 *         Name = "athena-data-catalog",
 *         Description = "Example Athena data catalog",
 *         Type = "LAMBDA",
 *         Parameters =
 *         {
 *             { "function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function" },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-athena-data-catalog" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := athena.NewDataCatalog(ctx, "example", &athena.DataCatalogArgs{
 * 			Name:        pulumi.String("athena-data-catalog"),
 * 			Description: pulumi.String("Example Athena data catalog"),
 * 			Type:        pulumi.String("LAMBDA"),
 * 			Parameters: pulumi.StringMap{
 * 				"function": pulumi.String("arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-athena-data-catalog"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.DataCatalog;
 * import com.pulumi.aws.athena.DataCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalog("example", DataCatalogArgs.builder()
 *             .name("athena-data-catalog")
 *             .description("Example Athena data catalog")
 *             .type("LAMBDA")
 *             .parameters(Map.of("function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function"))
 *             .tags(Map.of("Name", "example-athena-data-catalog"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:athena:DataCatalog
 *     properties:
 *       name: athena-data-catalog
 *       description: Example Athena data catalog
 *       type: LAMBDA
 *       parameters:
 *         function: arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function
 *       tags:
 *         Name: example-athena-data-catalog
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Hive based Data Catalog
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.athena.DataCatalog("example", {
 *     name: "hive-data-catalog",
 *     description: "Hive based Data Catalog",
 *     type: "HIVE",
 *     parameters: {
 *         "metadata-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.athena.DataCatalog("example",
 *     name="hive-data-catalog",
 *     description="Hive based Data Catalog",
 *     type="HIVE",
 *     parameters={
 *         "metadata-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Athena.DataCatalog("example", new()
 *     {
 *         Name = "hive-data-catalog",
 *         Description = "Hive based Data Catalog",
 *         Type = "HIVE",
 *         Parameters =
 *         {
 *             { "metadata-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := athena.NewDataCatalog(ctx, "example", &athena.DataCatalogArgs{
 * 			Name:        pulumi.String("hive-data-catalog"),
 * 			Description: pulumi.String("Hive based Data Catalog"),
 * 			Type:        pulumi.String("HIVE"),
 * 			Parameters: pulumi.StringMap{
 * 				"metadata-function": pulumi.String("arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.DataCatalog;
 * import com.pulumi.aws.athena.DataCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalog("example", DataCatalogArgs.builder()
 *             .name("hive-data-catalog")
 *             .description("Hive based Data Catalog")
 *             .type("HIVE")
 *             .parameters(Map.of("metadata-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:athena:DataCatalog
 *     properties:
 *       name: hive-data-catalog
 *       description: Hive based Data Catalog
 *       type: HIVE
 *       parameters:
 *         metadata-function: arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Glue based Data Catalog
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.athena.DataCatalog("example", {
 *     name: "glue-data-catalog",
 *     description: "Glue based Data Catalog",
 *     type: "GLUE",
 *     parameters: {
 *         "catalog-id": "123456789012",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.athena.DataCatalog("example",
 *     name="glue-data-catalog",
 *     description="Glue based Data Catalog",
 *     type="GLUE",
 *     parameters={
 *         "catalog-id": "123456789012",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Athena.DataCatalog("example", new()
 *     {
 *         Name = "glue-data-catalog",
 *         Description = "Glue based Data Catalog",
 *         Type = "GLUE",
 *         Parameters =
 *         {
 *             { "catalog-id", "123456789012" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := athena.NewDataCatalog(ctx, "example", &athena.DataCatalogArgs{
 * 			Name:        pulumi.String("glue-data-catalog"),
 * 			Description: pulumi.String("Glue based Data Catalog"),
 * 			Type:        pulumi.String("GLUE"),
 * 			Parameters: pulumi.StringMap{
 * 				"catalog-id": pulumi.String("123456789012"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.DataCatalog;
 * import com.pulumi.aws.athena.DataCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalog("example", DataCatalogArgs.builder()
 *             .name("glue-data-catalog")
 *             .description("Glue based Data Catalog")
 *             .type("GLUE")
 *             .parameters(Map.of("catalog-id", "123456789012"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:athena:DataCatalog
 *     properties:
 *       name: glue-data-catalog
 *       description: Glue based Data Catalog
 *       type: GLUE
 *       parameters:
 *         catalog-id: '123456789012'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Lambda based Data Catalog
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.athena.DataCatalog("example", {
 *     name: "lambda-data-catalog",
 *     description: "Lambda based Data Catalog",
 *     type: "LAMBDA",
 *     parameters: {
 *         "metadata-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1",
 *         "record-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.athena.DataCatalog("example",
 *     name="lambda-data-catalog",
 *     description="Lambda based Data Catalog",
 *     type="LAMBDA",
 *     parameters={
 *         "metadata-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1",
 *         "record-function": "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Athena.DataCatalog("example", new()
 *     {
 *         Name = "lambda-data-catalog",
 *         Description = "Lambda based Data Catalog",
 *         Type = "LAMBDA",
 *         Parameters =
 *         {
 *             { "metadata-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1" },
 *             { "record-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := athena.NewDataCatalog(ctx, "example", &athena.DataCatalogArgs{
 * 			Name:        pulumi.String("lambda-data-catalog"),
 * 			Description: pulumi.String("Lambda based Data Catalog"),
 * 			Type:        pulumi.String("LAMBDA"),
 * 			Parameters: pulumi.StringMap{
 * 				"metadata-function": pulumi.String("arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1"),
 * 				"record-function":   pulumi.String("arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.athena.DataCatalog;
 * import com.pulumi.aws.athena.DataCatalogArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataCatalog("example", DataCatalogArgs.builder()
 *             .name("lambda-data-catalog")
 *             .description("Lambda based Data Catalog")
 *             .type("LAMBDA")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("metadata-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1"),
 *                 Map.entry("record-function", "arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:athena:DataCatalog
 *     properties:
 *       name: lambda-data-catalog
 *       description: Lambda based Data Catalog
 *       type: LAMBDA
 *       parameters:
 *         metadata-function: arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-1
 *         record-function: arn:aws:lambda:eu-central-1:123456789012:function:not-important-lambda-function-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import data catalogs using their `name`. For example:
 * ```sh
 * $ pulumi import aws:athena/dataCatalog:DataCatalog example example-data-catalog
 * ```
 * @property description Description of the data catalog.
 * @property name Name of the data catalog. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
 * @property parameters Key value pairs that specifies the Lambda function or functions to use for the data catalog. The mapping used depends on the catalog type.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
 */
public data class DataCatalogArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.DataCatalogArgs> {
    override fun toJava(): com.pulumi.aws.athena.DataCatalogArgs =
        com.pulumi.aws.athena.DataCatalogArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataCatalogArgs].
 */
@PulumiTagMarker
public class DataCatalogArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description of the data catalog.
     */
    @JvmName("ewqrwrerbfqvdnii")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the data catalog. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
     */
    @JvmName("luuqevgkhrwahoby")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key value pairs that specifies the Lambda function or functions to use for the data catalog. The mapping used depends on the catalog type.
     */
    @JvmName("ektjxsjakrqgfvpf")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gmxjglceqbmorahp")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
     */
    @JvmName("pxljnjuwrhbjdtba")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description of the data catalog.
     */
    @JvmName("kgtxiatetllsqruk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the data catalog. The catalog name must be unique for the AWS account and can use a maximum of 128 alphanumeric, underscore, at sign, or hyphen characters.
     */
    @JvmName("yurbwicxhqsmoett")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key value pairs that specifies the Lambda function or functions to use for the data catalog. The mapping used depends on the catalog type.
     */
    @JvmName("hkclaiegulyuqhqd")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Key value pairs that specifies the Lambda function or functions to use for the data catalog. The mapping used depends on the catalog type.
     */
    @JvmName("gvqgputrvskeaubg")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("edrokdstvodbueor")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pdifbblfafermior")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Type of data catalog: `LAMBDA` for a federated catalog, `GLUE` for AWS Glue Catalog, or `HIVE` for an external hive metastore.
     */
    @JvmName("pygptjkgulplcapx")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataCatalogArgs = DataCatalogArgs(
        description = description,
        name = name,
        parameters = parameters,
        tags = tags,
        type = type,
    )
}
