@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.DatabaseArgs.builder
import com.pulumi.aws.athena.kotlin.inputs.DatabaseAclConfigurationArgs
import com.pulumi.aws.athena.kotlin.inputs.DatabaseAclConfigurationArgsBuilder
import com.pulumi.aws.athena.kotlin.inputs.DatabaseEncryptionConfigurationArgs
import com.pulumi.aws.athena.kotlin.inputs.DatabaseEncryptionConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Athena database.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleDatabase = new aws.athena.Database("example", {
 *     name: "database_name",
 *     bucket: example.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="example")
 * example_database = aws.athena.Database("example",
 *     name="database_name",
 *     bucket=example.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleDatabase = new Aws.Athena.Database("example", new()
 *     {
 *         Name = "database_name",
 *         Bucket = example.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = athena.NewDatabase(ctx, "example", &athena.DatabaseArgs{
 * 			Name:   pulumi.String("database_name"),
 * 			Bucket: example.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleDatabase = new Database("exampleDatabase", DatabaseArgs.builder()
 *             .name("database_name")
 *             .bucket(example.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: example
 *   exampleDatabase:
 *     type: aws:athena:Database
 *     name: example
 *     properties:
 *       name: database_name
 *       bucket: ${example.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Athena Databases using their name. For example:
 * ```sh
 * $ pulumi import aws:athena/database:Database example example
 * ```
 * Certain resource arguments, like `encryption_configuration` and `bucket`, do not have an API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property aclConfiguration That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
 * @property bucket Name of S3 bucket to save the results of the query execution.
 * @property comment Description of the database.
 * @property encryptionConfiguration Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
 * @property expectedBucketOwner AWS account ID that you expect to be the owner of the Amazon S3 bucket.
 * @property forceDestroy Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
 * @property name Name of the database to create.
 * @property properties Key-value map of custom metadata properties for the database definition.
 */
public data class DatabaseArgs(
    public val aclConfiguration: Output<DatabaseAclConfigurationArgs>? = null,
    public val bucket: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val encryptionConfiguration: Output<DatabaseEncryptionConfigurationArgs>? = null,
    public val expectedBucketOwner: Output<String>? = null,
    public val forceDestroy: Output<Boolean>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.DatabaseArgs> {
    override fun toJava(): com.pulumi.aws.athena.DatabaseArgs =
        com.pulumi.aws.athena.DatabaseArgs.builder()
            .aclConfiguration(aclConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .bucket(bucket?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expectedBucketOwner(expectedBucketOwner?.applyValue({ args0 -> args0 }))
            .forceDestroy(forceDestroy?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DatabaseArgs].
 */
@PulumiTagMarker
public class DatabaseArgsBuilder internal constructor() {
    private var aclConfiguration: Output<DatabaseAclConfigurationArgs>? = null

    private var bucket: Output<String>? = null

    private var comment: Output<String>? = null

    private var encryptionConfiguration: Output<DatabaseEncryptionConfigurationArgs>? = null

    private var expectedBucketOwner: Output<String>? = null

    private var forceDestroy: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("vhhhjcgcpbnooprn")
    public suspend fun aclConfiguration(`value`: Output<DatabaseAclConfigurationArgs>) {
        this.aclConfiguration = value
    }

    /**
     * @param value Name of S3 bucket to save the results of the query execution.
     */
    @JvmName("ixkbcspubstrwepe")
    public suspend fun bucket(`value`: Output<String>) {
        this.bucket = value
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("umtdupjpulhmjcbm")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("uhhhpcqxuhgsyjbh")
    public suspend fun encryptionConfiguration(`value`: Output<DatabaseEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("kpavlwssaptencqr")
    public suspend fun expectedBucketOwner(`value`: Output<String>) {
        this.expectedBucketOwner = value
    }

    /**
     * @param value Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
     */
    @JvmName("ugswqqattsvxmlps")
    public suspend fun forceDestroy(`value`: Output<Boolean>) {
        this.forceDestroy = value
    }

    /**
     * @param value Name of the database to create.
     */
    @JvmName("cyaitihenfmmcvhd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("poedjutjjixnfgeg")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("crisbmxsvtmvkdmb")
    public suspend fun aclConfiguration(`value`: DatabaseAclConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aclConfiguration = mapped
    }

    /**
     * @param argument That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
     */
    @JvmName("dymfehectmrwluwn")
    public suspend fun aclConfiguration(argument: suspend DatabaseAclConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseAclConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.aclConfiguration = mapped
    }

    /**
     * @param value Name of S3 bucket to save the results of the query execution.
     */
    @JvmName("ydvvpdggnpuwgdbm")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param value Description of the database.
     */
    @JvmName("vavrwvivhsxgwfgm")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("bbcjwunelxqxxmec")
    public suspend fun encryptionConfiguration(`value`: DatabaseEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument Encryption key block AWS Athena uses to decrypt the data in S3, such as an AWS Key Management Service (AWS KMS) key. See Encryption Configuration below.
     */
    @JvmName("eknyyjaythreqwer")
    public suspend fun encryptionConfiguration(argument: suspend DatabaseEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = DatabaseEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value AWS account ID that you expect to be the owner of the Amazon S3 bucket.
     */
    @JvmName("dyhnsucrljgesnhj")
    public suspend fun expectedBucketOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expectedBucketOwner = mapped
    }

    /**
     * @param value Boolean that indicates all tables should be deleted from the database so that the database can be destroyed without error. The tables are *not* recoverable.
     */
    @JvmName("txlfjgrebfrvfasw")
    public suspend fun forceDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceDestroy = mapped
    }

    /**
     * @param value Name of the database to create.
     */
    @JvmName("kxxodymwvpfpjpkd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("yrbsmtemrbyfwdwt")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values Key-value map of custom metadata properties for the database definition.
     */
    @JvmName("wdeynbucbfesgrom")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    internal fun build(): DatabaseArgs = DatabaseArgs(
        aclConfiguration = aclConfiguration,
        bucket = bucket,
        comment = comment,
        encryptionConfiguration = encryptionConfiguration,
        expectedBucketOwner = expectedBucketOwner,
        forceDestroy = forceDestroy,
        name = name,
        properties = properties,
    )
}
