@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [NamedQuery].
 */
@PulumiTagMarker
public class NamedQueryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamedQueryArgs = NamedQueryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamedQueryArgsBuilder.() -> Unit) {
        val builder = NamedQueryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NamedQuery {
        val builtJavaResource = com.pulumi.aws.athena.NamedQuery(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NamedQuery(builtJavaResource)
    }
}

/**
 * Provides an Athena Named Query resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hoge = new aws.s3.BucketV2("hoge", {bucket: "tf-test"});
 * const test = new aws.kms.Key("test", {
 *     deletionWindowInDays: 7,
 *     description: "Athena KMS Key",
 * });
 * const testWorkgroup = new aws.athena.Workgroup("test", {
 *     name: "example",
 *     configuration: {
 *         resultConfiguration: {
 *             encryptionConfiguration: {
 *                 encryptionOption: "SSE_KMS",
 *                 kmsKeyArn: test.arn,
 *             },
 *         },
 *     },
 * });
 * const hogeDatabase = new aws.athena.Database("hoge", {
 *     name: "users",
 *     bucket: hoge.id,
 * });
 * const foo = new aws.athena.NamedQuery("foo", {
 *     name: "bar",
 *     workgroup: testWorkgroup.id,
 *     database: hogeDatabase.name,
 *     query: pulumi.interpolate`SELECT * FROM ${hogeDatabase.name} limit 10;`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hoge = aws.s3.BucketV2("hoge", bucket="tf-test")
 * test = aws.kms.Key("test",
 *     deletion_window_in_days=7,
 *     description="Athena KMS Key")
 * test_workgroup = aws.athena.Workgroup("test",
 *     name="example",
 *     configuration={
 *         "result_configuration": {
 *             "encryption_configuration": {
 *                 "encryption_option": "SSE_KMS",
 *                 "kms_key_arn": test.arn,
 *             },
 *         },
 *     })
 * hoge_database = aws.athena.Database("hoge",
 *     name="users",
 *     bucket=hoge.id)
 * foo = aws.athena.NamedQuery("foo",
 *     name="bar",
 *     workgroup=test_workgroup.id,
 *     database=hoge_database.name,
 *     query=hoge_database.name.apply(lambda name: f"SELECT * FROM {name} limit 10;"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hoge = new Aws.S3.BucketV2("hoge", new()
 *     {
 *         Bucket = "tf-test",
 *     });
 *     var test = new Aws.Kms.Key("test", new()
 *     {
 *         DeletionWindowInDays = 7,
 *         Description = "Athena KMS Key",
 *     });
 *     var testWorkgroup = new Aws.Athena.Workgroup("test", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.Athena.Inputs.WorkgroupConfigurationArgs
 *         {
 *             ResultConfiguration = new Aws.Athena.Inputs.WorkgroupConfigurationResultConfigurationArgs
 *             {
 *                 EncryptionConfiguration = new Aws.Athena.Inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs
 *                 {
 *                     EncryptionOption = "SSE_KMS",
 *                     KmsKeyArn = test.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var hogeDatabase = new Aws.Athena.Database("hoge", new()
 *     {
 *         Name = "users",
 *         Bucket = hoge.Id,
 *     });
 *     var foo = new Aws.Athena.NamedQuery("foo", new()
 *     {
 *         Name = "bar",
 *         Workgroup = testWorkgroup.Id,
 *         Database = hogeDatabase.Name,
 *         Query = hogeDatabase.Name.Apply(name => $"SELECT * FROM {name} limit 10;"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		hoge, err := s3.NewBucketV2(ctx, "hoge", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := kms.NewKey(ctx, "test", &kms.KeyArgs{
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			Description:          pulumi.String("Athena KMS Key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testWorkgroup, err := athena.NewWorkgroup(ctx, "test", &athena.WorkgroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &athena.WorkgroupConfigurationArgs{
 * 				ResultConfiguration: &athena.WorkgroupConfigurationResultConfigurationArgs{
 * 					EncryptionConfiguration: &athena.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs{
 * 						EncryptionOption: pulumi.String("SSE_KMS"),
 * 						KmsKeyArn:        test.Arn,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		hogeDatabase, err := athena.NewDatabase(ctx, "hoge", &athena.DatabaseArgs{
 * 			Name:   pulumi.String("users"),
 * 			Bucket: hoge.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = athena.NewNamedQuery(ctx, "foo", &athena.NamedQueryArgs{
 * 			Name:      pulumi.String("bar"),
 * 			Workgroup: testWorkgroup.ID(),
 * 			Database:  hogeDatabase.Name,
 * 			Query: hogeDatabase.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("SELECT * FROM %v limit 10;", name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.NamedQuery;
 * import com.pulumi.aws.athena.NamedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hoge = new BucketV2("hoge", BucketV2Args.builder()
 *             .bucket("tf-test")
 *             .build());
 *         var test = new Key("test", KeyArgs.builder()
 *             .deletionWindowInDays(7)
 *             .description("Athena KMS Key")
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup", WorkgroupArgs.builder()
 *             .name("example")
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(test.arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var hogeDatabase = new Database("hogeDatabase", DatabaseArgs.builder()
 *             .name("users")
 *             .bucket(hoge.id())
 *             .build());
 *         var foo = new NamedQuery("foo", NamedQueryArgs.builder()
 *             .name("bar")
 *             .workgroup(testWorkgroup.id())
 *             .database(hogeDatabase.name())
 *             .query(hogeDatabase.name().applyValue(name -> String.format("SELECT * FROM %s limit 10;", name)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hoge:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test
 *   test:
 *     type: aws:kms:Key
 *     properties:
 *       deletionWindowInDays: 7
 *       description: Athena KMS Key
 *   testWorkgroup:
 *     type: aws:athena:Workgroup
 *     name: test
 *     properties:
 *       name: example
 *       configuration:
 *         resultConfiguration:
 *           encryptionConfiguration:
 *             encryptionOption: SSE_KMS
 *             kmsKeyArn: ${test.arn}
 *   hogeDatabase:
 *     type: aws:athena:Database
 *     name: hoge
 *     properties:
 *       name: users
 *       bucket: ${hoge.id}
 *   foo:
 *     type: aws:athena:NamedQuery
 *     properties:
 *       name: bar
 *       workgroup: ${testWorkgroup.id}
 *       database: ${hogeDatabase.name}
 *       query: SELECT * FROM ${hogeDatabase.name} limit 10;
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Athena Named Query using the query ID. For example:
 * ```sh
 * $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
 * ```
 */
public class NamedQuery internal constructor(
    override val javaResource: com.pulumi.aws.athena.NamedQuery,
) : KotlinCustomResource(javaResource, NamedQueryMapper) {
    /**
     * Database to which the query belongs.
     */
    public val database: Output<String>
        get() = javaResource.database().applyValue({ args0 -> args0 })

    /**
     * Brief explanation of the query. Maximum length of 1024.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Plain language name for the query. Maximum length of 128.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    public val query: Output<String>
        get() = javaResource.query().applyValue({ args0 -> args0 })

    /**
     * Workgroup to which the query belongs. Defaults to `primary`
     */
    public val workgroup: Output<String>?
        get() = javaResource.workgroup().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object NamedQueryMapper : ResourceMapper<NamedQuery> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.athena.NamedQuery::class == javaResource::class

    override fun map(javaResource: Resource): NamedQuery = NamedQuery(
        javaResource as
            com.pulumi.aws.athena.NamedQuery,
    )
}

/**
 * @see [NamedQuery].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamedQuery].
 */
public suspend fun namedQuery(name: String, block: suspend NamedQueryResourceBuilder.() -> Unit): NamedQuery {
    val builder = NamedQueryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamedQuery].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namedQuery(name: String): NamedQuery {
    val builder = NamedQueryResourceBuilder()
    builder.name(name)
    return builder.build()
}
