@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.NamedQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Athena Named Query resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hoge = new aws.s3.BucketV2("hoge", {bucket: "tf-test"});
 * const test = new aws.kms.Key("test", {
 *     deletionWindowInDays: 7,
 *     description: "Athena KMS Key",
 * });
 * const testWorkgroup = new aws.athena.Workgroup("test", {
 *     name: "example",
 *     configuration: {
 *         resultConfiguration: {
 *             encryptionConfiguration: {
 *                 encryptionOption: "SSE_KMS",
 *                 kmsKeyArn: test.arn,
 *             },
 *         },
 *     },
 * });
 * const hogeDatabase = new aws.athena.Database("hoge", {
 *     name: "users",
 *     bucket: hoge.id,
 * });
 * const foo = new aws.athena.NamedQuery("foo", {
 *     name: "bar",
 *     workgroup: testWorkgroup.id,
 *     database: hogeDatabase.name,
 *     query: pulumi.interpolate`SELECT * FROM ${hogeDatabase.name} limit 10;`,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hoge = aws.s3.BucketV2("hoge", bucket="tf-test")
 * test = aws.kms.Key("test",
 *     deletion_window_in_days=7,
 *     description="Athena KMS Key")
 * test_workgroup = aws.athena.Workgroup("test",
 *     name="example",
 *     configuration={
 *         "result_configuration": {
 *             "encryption_configuration": {
 *                 "encryption_option": "SSE_KMS",
 *                 "kms_key_arn": test.arn,
 *             },
 *         },
 *     })
 * hoge_database = aws.athena.Database("hoge",
 *     name="users",
 *     bucket=hoge.id)
 * foo = aws.athena.NamedQuery("foo",
 *     name="bar",
 *     workgroup=test_workgroup.id,
 *     database=hoge_database.name,
 *     query=hoge_database.name.apply(lambda name: f"SELECT * FROM {name} limit 10;"))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hoge = new Aws.S3.BucketV2("hoge", new()
 *     {
 *         Bucket = "tf-test",
 *     });
 *     var test = new Aws.Kms.Key("test", new()
 *     {
 *         DeletionWindowInDays = 7,
 *         Description = "Athena KMS Key",
 *     });
 *     var testWorkgroup = new Aws.Athena.Workgroup("test", new()
 *     {
 *         Name = "example",
 *         Configuration = new Aws.Athena.Inputs.WorkgroupConfigurationArgs
 *         {
 *             ResultConfiguration = new Aws.Athena.Inputs.WorkgroupConfigurationResultConfigurationArgs
 *             {
 *                 EncryptionConfiguration = new Aws.Athena.Inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs
 *                 {
 *                     EncryptionOption = "SSE_KMS",
 *                     KmsKeyArn = test.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var hogeDatabase = new Aws.Athena.Database("hoge", new()
 *     {
 *         Name = "users",
 *         Bucket = hoge.Id,
 *     });
 *     var foo = new Aws.Athena.NamedQuery("foo", new()
 *     {
 *         Name = "bar",
 *         Workgroup = testWorkgroup.Id,
 *         Database = hogeDatabase.Name,
 *         Query = hogeDatabase.Name.Apply(name => $"SELECT * FROM {name} limit 10;"),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		hoge, err := s3.NewBucketV2(ctx, "hoge", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("tf-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test, err := kms.NewKey(ctx, "test", &kms.KeyArgs{
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			Description:          pulumi.String("Athena KMS Key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testWorkgroup, err := athena.NewWorkgroup(ctx, "test", &athena.WorkgroupArgs{
 * 			Name: pulumi.String("example"),
 * 			Configuration: &athena.WorkgroupConfigurationArgs{
 * 				ResultConfiguration: &athena.WorkgroupConfigurationResultConfigurationArgs{
 * 					EncryptionConfiguration: &athena.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs{
 * 						EncryptionOption: pulumi.String("SSE_KMS"),
 * 						KmsKeyArn:        test.Arn,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		hogeDatabase, err := athena.NewDatabase(ctx, "hoge", &athena.DatabaseArgs{
 * 			Name:   pulumi.String("users"),
 * 			Bucket: hoge.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = athena.NewNamedQuery(ctx, "foo", &athena.NamedQueryArgs{
 * 			Name:      pulumi.String("bar"),
 * 			Workgroup: testWorkgroup.ID(),
 * 			Database:  hogeDatabase.Name,
 * 			Query: hogeDatabase.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("SELECT * FROM %v limit 10;", name), nil
 * 			}).(pulumi.StringOutput),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationArgs;
 * import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.NamedQuery;
 * import com.pulumi.aws.athena.NamedQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hoge = new BucketV2("hoge", BucketV2Args.builder()
 *             .bucket("tf-test")
 *             .build());
 *         var test = new Key("test", KeyArgs.builder()
 *             .deletionWindowInDays(7)
 *             .description("Athena KMS Key")
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup", WorkgroupArgs.builder()
 *             .name("example")
 *             .configuration(WorkgroupConfigurationArgs.builder()
 *                 .resultConfiguration(WorkgroupConfigurationResultConfigurationArgs.builder()
 *                     .encryptionConfiguration(WorkgroupConfigurationResultConfigurationEncryptionConfigurationArgs.builder()
 *                         .encryptionOption("SSE_KMS")
 *                         .kmsKeyArn(test.arn())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *         var hogeDatabase = new Database("hogeDatabase", DatabaseArgs.builder()
 *             .name("users")
 *             .bucket(hoge.id())
 *             .build());
 *         var foo = new NamedQuery("foo", NamedQueryArgs.builder()
 *             .name("bar")
 *             .workgroup(testWorkgroup.id())
 *             .database(hogeDatabase.name())
 *             .query(hogeDatabase.name().applyValue(name -> String.format("SELECT * FROM %s limit 10;", name)))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hoge:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test
 *   test:
 *     type: aws:kms:Key
 *     properties:
 *       deletionWindowInDays: 7
 *       description: Athena KMS Key
 *   testWorkgroup:
 *     type: aws:athena:Workgroup
 *     name: test
 *     properties:
 *       name: example
 *       configuration:
 *         resultConfiguration:
 *           encryptionConfiguration:
 *             encryptionOption: SSE_KMS
 *             kmsKeyArn: ${test.arn}
 *   hogeDatabase:
 *     type: aws:athena:Database
 *     name: hoge
 *     properties:
 *       name: users
 *       bucket: ${hoge.id}
 *   foo:
 *     type: aws:athena:NamedQuery
 *     properties:
 *       name: bar
 *       workgroup: ${testWorkgroup.id}
 *       database: ${hogeDatabase.name}
 *       query: SELECT * FROM ${hogeDatabase.name} limit 10;
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Athena Named Query using the query ID. For example:
 * ```sh
 * $ pulumi import aws:athena/namedQuery:NamedQuery example 0123456789
 * ```
 * @property database Database to which the query belongs.
 * @property description Brief explanation of the query. Maximum length of 1024.
 * @property name Plain language name for the query. Maximum length of 128.
 * @property query Text of the query itself. In other words, all query statements. Maximum length of 262144.
 * @property workgroup Workgroup to which the query belongs. Defaults to `primary`
 */
public data class NamedQueryArgs(
    public val database: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val query: Output<String>? = null,
    public val workgroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.NamedQueryArgs> {
    override fun toJava(): com.pulumi.aws.athena.NamedQueryArgs =
        com.pulumi.aws.athena.NamedQueryArgs.builder()
            .database(database?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .workgroup(workgroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamedQueryArgs].
 */
@PulumiTagMarker
public class NamedQueryArgsBuilder internal constructor() {
    private var database: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var query: Output<String>? = null

    private var workgroup: Output<String>? = null

    /**
     * @param value Database to which the query belongs.
     */
    @JvmName("cubtmbtvijesgidr")
    public suspend fun database(`value`: Output<String>) {
        this.database = value
    }

    /**
     * @param value Brief explanation of the query. Maximum length of 1024.
     */
    @JvmName("mbkglkthaubkwjbd")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Plain language name for the query. Maximum length of 128.
     */
    @JvmName("hswenmsrjjehrtxs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    @JvmName("upwiokbduimiqdtp")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value Workgroup to which the query belongs. Defaults to `primary`
     */
    @JvmName("byblhxdfuxcghyyf")
    public suspend fun workgroup(`value`: Output<String>) {
        this.workgroup = value
    }

    /**
     * @param value Database to which the query belongs.
     */
    @JvmName("qljidefjnapxhwgj")
    public suspend fun database(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.database = mapped
    }

    /**
     * @param value Brief explanation of the query. Maximum length of 1024.
     */
    @JvmName("xvfbsnaabgrdjuxg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Plain language name for the query. Maximum length of 128.
     */
    @JvmName("blonssiecebyiqjh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Text of the query itself. In other words, all query statements. Maximum length of 262144.
     */
    @JvmName("wageksvyjurougyf")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Workgroup to which the query belongs. Defaults to `primary`
     */
    @JvmName("albwvsmfnxbudwje")
    public suspend fun workgroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroup = mapped
    }

    internal fun build(): NamedQueryArgs = NamedQueryArgs(
        database = database,
        description = description,
        name = name,
        query = query,
        workgroup = workgroup,
    )
}
