@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin

import com.pulumi.aws.athena.PreparedStatementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an Athena Prepared Statement.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.s3.BucketV2("test", {
 *     bucket: "tf-test",
 *     forceDestroy: true,
 * });
 * const testWorkgroup = new aws.athena.Workgroup("test", {name: "tf-test"});
 * const testDatabase = new aws.athena.Database("test", {
 *     name: "example",
 *     bucket: test.bucket,
 * });
 * const testPreparedStatement = new aws.athena.PreparedStatement("test", {
 *     name: "tf_test",
 *     queryStatement: pulumi.interpolate`SELECT * FROM ${testDatabase.name} WHERE x = ?`,
 *     workgroup: testWorkgroup.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.s3.BucketV2("test",
 *     bucket="tf-test",
 *     force_destroy=True)
 * test_workgroup = aws.athena.Workgroup("test", name="tf-test")
 * test_database = aws.athena.Database("test",
 *     name="example",
 *     bucket=test.bucket)
 * test_prepared_statement = aws.athena.PreparedStatement("test",
 *     name="tf_test",
 *     query_statement=test_database.name.apply(lambda name: f"SELECT * FROM {name} WHERE x = ?"),
 *     workgroup=test_workgroup.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.S3.BucketV2("test", new()
 *     {
 *         Bucket = "tf-test",
 *         ForceDestroy = true,
 *     });
 *     var testWorkgroup = new Aws.Athena.Workgroup("test", new()
 *     {
 *         Name = "tf-test",
 *     });
 *     var testDatabase = new Aws.Athena.Database("test", new()
 *     {
 *         Name = "example",
 *         Bucket = test.Bucket,
 *     });
 *     var testPreparedStatement = new Aws.Athena.PreparedStatement("test", new()
 *     {
 *         Name = "tf_test",
 *         QueryStatement = testDatabase.Name.Apply(name => $"SELECT * FROM {name} WHERE x = ?"),
 *         Workgroup = testWorkgroup.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/athena"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := s3.NewBucketV2(ctx, "test", &s3.BucketV2Args{
 * 			Bucket:       pulumi.String("tf-test"),
 * 			ForceDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testWorkgroup, err := athena.NewWorkgroup(ctx, "test", &athena.WorkgroupArgs{
 * 			Name: pulumi.String("tf-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testDatabase, err := athena.NewDatabase(ctx, "test", &athena.DatabaseArgs{
 * 			Name:   pulumi.String("example"),
 * 			Bucket: test.Bucket,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = athena.NewPreparedStatement(ctx, "test", &athena.PreparedStatementArgs{
 * 			Name: pulumi.String("tf_test"),
 * 			QueryStatement: testDatabase.Name.ApplyT(func(name string) (string, error) {
 * 				return fmt.Sprintf("SELECT * FROM %v WHERE x = ?", name), nil
 * 			}).(pulumi.StringOutput),
 * 			Workgroup: testWorkgroup.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.athena.Workgroup;
 * import com.pulumi.aws.athena.WorkgroupArgs;
 * import com.pulumi.aws.athena.Database;
 * import com.pulumi.aws.athena.DatabaseArgs;
 * import com.pulumi.aws.athena.PreparedStatement;
 * import com.pulumi.aws.athena.PreparedStatementArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new BucketV2("test", BucketV2Args.builder()
 *             .bucket("tf-test")
 *             .forceDestroy(true)
 *             .build());
 *         var testWorkgroup = new Workgroup("testWorkgroup", WorkgroupArgs.builder()
 *             .name("tf-test")
 *             .build());
 *         var testDatabase = new Database("testDatabase", DatabaseArgs.builder()
 *             .name("example")
 *             .bucket(test.bucket())
 *             .build());
 *         var testPreparedStatement = new PreparedStatement("testPreparedStatement", PreparedStatementArgs.builder()
 *             .name("tf_test")
 *             .queryStatement(testDatabase.name().applyValue(name -> String.format("SELECT * FROM %s WHERE x = ?", name)))
 *             .workgroup(testWorkgroup.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: tf-test
 *       forceDestroy: true
 *   testWorkgroup:
 *     type: aws:athena:Workgroup
 *     name: test
 *     properties:
 *       name: tf-test
 *   testDatabase:
 *     type: aws:athena:Database
 *     name: test
 *     properties:
 *       name: example
 *       bucket: ${test.bucket}
 *   testPreparedStatement:
 *     type: aws:athena:PreparedStatement
 *     name: test
 *     properties:
 *       name: tf_test
 *       queryStatement: SELECT * FROM ${testDatabase.name} WHERE x = ?
 *       workgroup: ${testWorkgroup.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Athena Prepared Statement using the `WORKGROUP-NAME/STATEMENT-NAME`. For example:
 * ```sh
 * $ pulumi import aws:athena/preparedStatement:PreparedStatement example 12345abcde/example
 * ```
 * @property description Brief explanation of prepared statement. Maximum length of 1024.
 * @property name The name of the prepared statement. Maximum length of 256.
 * @property queryStatement The query string for the prepared statement.
 * @property workgroup The name of the workgroup to which the prepared statement belongs.
 */
public data class PreparedStatementArgs(
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val queryStatement: Output<String>? = null,
    public val workgroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.PreparedStatementArgs> {
    override fun toJava(): com.pulumi.aws.athena.PreparedStatementArgs =
        com.pulumi.aws.athena.PreparedStatementArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .queryStatement(queryStatement?.applyValue({ args0 -> args0 }))
            .workgroup(workgroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PreparedStatementArgs].
 */
@PulumiTagMarker
public class PreparedStatementArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var queryStatement: Output<String>? = null

    private var workgroup: Output<String>? = null

    /**
     * @param value Brief explanation of prepared statement. Maximum length of 1024.
     */
    @JvmName("mpteievkkpgvppyf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the prepared statement. Maximum length of 256.
     */
    @JvmName("fuaaimcbvilgeuvg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The query string for the prepared statement.
     */
    @JvmName("ktmxagfoughrviiy")
    public suspend fun queryStatement(`value`: Output<String>) {
        this.queryStatement = value
    }

    /**
     * @param value The name of the workgroup to which the prepared statement belongs.
     */
    @JvmName("lrvuumfaxyiwuhud")
    public suspend fun workgroup(`value`: Output<String>) {
        this.workgroup = value
    }

    /**
     * @param value Brief explanation of prepared statement. Maximum length of 1024.
     */
    @JvmName("aqvvephdvqmloduu")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the prepared statement. Maximum length of 256.
     */
    @JvmName("sapfjafeytvmjbxd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The query string for the prepared statement.
     */
    @JvmName("apytfgxrfwfwdpei")
    public suspend fun queryStatement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryStatement = mapped
    }

    /**
     * @param value The name of the workgroup to which the prepared statement belongs.
     */
    @JvmName("grudxsdtnhkuarxd")
    public suspend fun workgroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workgroup = mapped
    }

    internal fun build(): PreparedStatementArgs = PreparedStatementArgs(
        description = description,
        name = name,
        queryStatement = queryStatement,
        workgroup = workgroup,
    )
}
