@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.WorkgroupConfigurationEngineVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property effectiveEngineVersion The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
 * @property selectedEngineVersion Requested engine version. Defaults to `AUTO`.
 */
public data class WorkgroupConfigurationEngineVersionArgs(
    public val effectiveEngineVersion: Output<String>? = null,
    public val selectedEngineVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.athena.inputs.WorkgroupConfigurationEngineVersionArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.WorkgroupConfigurationEngineVersionArgs =
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationEngineVersionArgs.builder()
            .effectiveEngineVersion(effectiveEngineVersion?.applyValue({ args0 -> args0 }))
            .selectedEngineVersion(selectedEngineVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupConfigurationEngineVersionArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigurationEngineVersionArgsBuilder internal constructor() {
    private var effectiveEngineVersion: Output<String>? = null

    private var selectedEngineVersion: Output<String>? = null

    /**
     * @param value The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
     */
    @JvmName("fdxfqndwkotlynox")
    public suspend fun effectiveEngineVersion(`value`: Output<String>) {
        this.effectiveEngineVersion = value
    }

    /**
     * @param value Requested engine version. Defaults to `AUTO`.
     */
    @JvmName("mmkedpnfnyfnqaud")
    public suspend fun selectedEngineVersion(`value`: Output<String>) {
        this.selectedEngineVersion = value
    }

    /**
     * @param value The engine version on which the query runs. If `selected_engine_version` is set to `AUTO`, the effective engine version is chosen by Athena.
     */
    @JvmName("svmcujytocjkanvt")
    public suspend fun effectiveEngineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.effectiveEngineVersion = mapped
    }

    /**
     * @param value Requested engine version. Defaults to `AUTO`.
     */
    @JvmName("hybeavaetfyyfkkd")
    public suspend fun selectedEngineVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectedEngineVersion = mapped
    }

    internal fun build(): WorkgroupConfigurationEngineVersionArgs =
        WorkgroupConfigurationEngineVersionArgs(
            effectiveEngineVersion = effectiveEngineVersion,
            selectedEngineVersion = selectedEngineVersion,
        )
}
