@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.inputs

import com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationAclConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property s3AclOption Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
 */
public data class WorkgroupConfigurationResultConfigurationAclConfigurationArgs(
    public val s3AclOption: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationAclConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationAclConfigurationArgs =
        com.pulumi.aws.athena.inputs.WorkgroupConfigurationResultConfigurationAclConfigurationArgs.builder()
            .s3AclOption(s3AclOption.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkgroupConfigurationResultConfigurationAclConfigurationArgs].
 */
@PulumiTagMarker
public class WorkgroupConfigurationResultConfigurationAclConfigurationArgsBuilder internal constructor() {
    private var s3AclOption: Output<String>? = null

    /**
     * @param value Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
     */
    @JvmName("nnjuhcucmccdybbw")
    public suspend fun s3AclOption(`value`: Output<String>) {
        this.s3AclOption = value
    }

    /**
     * @param value Amazon S3 canned ACL that Athena should specify when storing query results. Valid value is `BUCKET_OWNER_FULL_CONTROL`.
     */
    @JvmName("ewtpgdmqoydmtgqf")
    public suspend fun s3AclOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.s3AclOption = mapped
    }

    internal fun build(): WorkgroupConfigurationResultConfigurationAclConfigurationArgs =
        WorkgroupConfigurationResultConfigurationAclConfigurationArgs(
            s3AclOption = s3AclOption ?: throw PulumiNullFieldException("s3AclOption"),
        )
}
