@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bytesScannedCutoffPerQuery Integer for the upper data usage limit (cutoff) for the amount of bytes a single query in a workgroup is allowed to scan. Must be at least `10485760`.
 * @property enforceWorkgroupConfiguration Boolean whether the settings for the workgroup override client-side settings. For more information, see [Workgroup Settings Override Client-Side Settings](https://docs.aws.amazon.com/athena/latest/ug/workgroups-settings-override.html). Defaults to `true`.
 * @property engineVersion Configuration block for the Athena Engine Versioning. For more information, see [Athena Engine Versioning](https://docs.aws.amazon.com/athena/latest/ug/engine-versions.html). See Engine Version below.
 * @property executionRole Role used in a notebook session for accessing the user's resources.
 * @property publishCloudwatchMetricsEnabled Boolean whether Amazon CloudWatch metrics are enabled for the workgroup. Defaults to `true`.
 * @property requesterPaysEnabled If set to true , allows members assigned to a workgroup to reference Amazon S3 Requester Pays buckets in queries. If set to false , workgroup members cannot query data from Requester Pays buckets, and queries that retrieve data from Requester Pays buckets cause an error. The default is false . For more information about Requester Pays buckets, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/dev/RequesterPaysBuckets.html) in the Amazon Simple Storage Service Developer Guide.
 * @property resultConfiguration Configuration block with result settings. See Result Configuration below.
 */
public data class WorkgroupConfiguration(
    public val bytesScannedCutoffPerQuery: Int? = null,
    public val enforceWorkgroupConfiguration: Boolean? = null,
    public val engineVersion: WorkgroupConfigurationEngineVersion? = null,
    public val executionRole: String? = null,
    public val publishCloudwatchMetricsEnabled: Boolean? = null,
    public val requesterPaysEnabled: Boolean? = null,
    public val resultConfiguration: WorkgroupConfigurationResultConfiguration? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.athena.outputs.WorkgroupConfiguration): WorkgroupConfiguration = WorkgroupConfiguration(
            bytesScannedCutoffPerQuery = javaType.bytesScannedCutoffPerQuery().map({ args0 ->
                args0
            }).orElse(null),
            enforceWorkgroupConfiguration = javaType.enforceWorkgroupConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            engineVersion = javaType.engineVersion().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfigurationEngineVersion.Companion.toKotlin(args0)
                })
            }).orElse(null),
            executionRole = javaType.executionRole().map({ args0 -> args0 }).orElse(null),
            publishCloudwatchMetricsEnabled = javaType.publishCloudwatchMetricsEnabled().map({ args0 ->
                args0
            }).orElse(null),
            requesterPaysEnabled = javaType.requesterPaysEnabled().map({ args0 -> args0 }).orElse(null),
            resultConfiguration = javaType.resultConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfigurationResultConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
