@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.athena.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property aclConfiguration That an Amazon S3 canned ACL should be set to control ownership of stored query results. See ACL Configuration below.
 * @property encryptionConfiguration Configuration block with encryption settings. See Encryption Configuration below.
 * @property expectedBucketOwner AWS account ID that you expect to be the owner of the Amazon S3 bucket.
 * @property outputLocation Location in Amazon S3 where your query results are stored, such as `s3://path/to/query/bucket/`. For more information, see [Queries and Query Result Files](https://docs.aws.amazon.com/athena/latest/ug/querying.html).
 */
public data class WorkgroupConfigurationResultConfiguration(
    public val aclConfiguration: WorkgroupConfigurationResultConfigurationAclConfiguration? = null,
    public val encryptionConfiguration: WorkgroupConfigurationResultConfigurationEncryptionConfiguration? = null,
    public val expectedBucketOwner: String? = null,
    public val outputLocation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.athena.outputs.WorkgroupConfigurationResultConfiguration): WorkgroupConfigurationResultConfiguration = WorkgroupConfigurationResultConfiguration(
            aclConfiguration = javaType.aclConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfigurationResultConfigurationAclConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryptionConfiguration = javaType.encryptionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.athena.kotlin.outputs.WorkgroupConfigurationResultConfigurationEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expectedBucketOwner = javaType.expectedBucketOwner().map({ args0 -> args0 }).orElse(null),
            outputLocation = javaType.outputLocation().map({ args0 -> args0 }).orElse(null),
        )
    }
}
