@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccountRegistration].
 */
@PulumiTagMarker
public class AccountRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccountRegistrationArgs = AccountRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccountRegistrationArgsBuilder.() -> Unit) {
        val builder = AccountRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccountRegistration {
        val builtJavaResource = com.pulumi.aws.auditmanager.AccountRegistration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccountRegistration(builtJavaResource)
    }
}

/**
 * Resource for managing AWS Audit Manager Account Registration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.AccountRegistration("example", {});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.AccountRegistration("example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.AccountRegistration("example");
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewAccountRegistration(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration("example");
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:AccountRegistration
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Deregister On Destroy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.AccountRegistration("example", {deregisterOnDestroy: true});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.AccountRegistration("example", deregister_on_destroy=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.AccountRegistration("example", new()
 *     {
 *         DeregisterOnDestroy = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewAccountRegistration(ctx, "example", &auditmanager.AccountRegistrationArgs{
 * 			DeregisterOnDestroy: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AccountRegistration;
 * import com.pulumi.aws.auditmanager.AccountRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccountRegistration("example", AccountRegistrationArgs.builder()
 *             .deregisterOnDestroy(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:AccountRegistration
 *     properties:
 *       deregisterOnDestroy: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Account Registration resources using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/accountRegistration:AccountRegistration example us-east-1
 * ```
 */
public class AccountRegistration internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.AccountRegistration,
) : KotlinCustomResource(javaResource, AccountRegistrationMapper) {
    /**
     * Identifier for the delegated administrator account.
     */
    public val delegatedAdminAccount: Output<String>?
        get() = javaResource.delegatedAdminAccount().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to deregister AuditManager in the account upon destruction. Defaults to `false` (ie. AuditManager will remain active in the account, even if this resource is removed).
     */
    public val deregisterOnDestroy: Output<Boolean>?
        get() = javaResource.deregisterOnDestroy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * KMS key identifier.
     */
    public val kmsKey: Output<String>?
        get() = javaResource.kmsKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Status of the account registration request.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object AccountRegistrationMapper : ResourceMapper<AccountRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.AccountRegistration::class == javaResource::class

    override fun map(javaResource: Resource): AccountRegistration = AccountRegistration(
        javaResource
            as com.pulumi.aws.auditmanager.AccountRegistration,
    )
}

/**
 * @see [AccountRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccountRegistration].
 */
public suspend fun accountRegistration(
    name: String,
    block: suspend AccountRegistrationResourceBuilder.() -> Unit,
): AccountRegistration {
    val builder = AccountRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccountRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accountRegistration(name: String): AccountRegistration {
    val builder = AccountRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
