@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AssessmentArgs.builder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentAssessmentReportsDestinationArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentAssessmentReportsDestinationArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentRoleArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentRoleArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentScopeArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.AssessmentScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Assessment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.auditmanager.Assessment("test", {
 *     name: "example",
 *     assessmentReportsDestination: {
 *         destination: `s3://${testAwsS3Bucket.id}`,
 *         destinationType: "S3",
 *     },
 *     frameworkId: testAwsAuditmanagerFramework.id,
 *     roles: [{
 *         roleArn: testAwsIamRole.arn,
 *         roleType: "PROCESS_OWNER",
 *     }],
 *     scope: {
 *         awsAccounts: [{
 *             id: current.accountId,
 *         }],
 *         awsServices: [{
 *             serviceName: "S3",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.auditmanager.Assessment("test",
 *     name="example",
 *     assessment_reports_destination={
 *         "destination": f"s3://{test_aws_s3_bucket['id']}",
 *         "destination_type": "S3",
 *     },
 *     framework_id=test_aws_auditmanager_framework["id"],
 *     roles=[{
 *         "role_arn": test_aws_iam_role["arn"],
 *         "role_type": "PROCESS_OWNER",
 *     }],
 *     scope={
 *         "aws_accounts": [{
 *             "id": current["accountId"],
 *         }],
 *         "aws_services": [{
 *             "service_name": "S3",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Auditmanager.Assessment("test", new()
 *     {
 *         Name = "example",
 *         AssessmentReportsDestination = new Aws.Auditmanager.Inputs.AssessmentAssessmentReportsDestinationArgs
 *         {
 *             Destination = $"s3://{testAwsS3Bucket.Id}",
 *             DestinationType = "S3",
 *         },
 *         FrameworkId = testAwsAuditmanagerFramework.Id,
 *         Roles = new[]
 *         {
 *             new Aws.Auditmanager.Inputs.AssessmentRoleArgs
 *             {
 *                 RoleArn = testAwsIamRole.Arn,
 *                 RoleType = "PROCESS_OWNER",
 *             },
 *         },
 *         Scope = new Aws.Auditmanager.Inputs.AssessmentScopeArgs
 *         {
 *             AwsAccounts = new[]
 *             {
 *                 new Aws.Auditmanager.Inputs.AssessmentScopeAwsAccountArgs
 *                 {
 *                     Id = current.AccountId,
 *                 },
 *             },
 *             AwsServices = new[]
 *             {
 *                 new Aws.Auditmanager.Inputs.AssessmentScopeAwsServiceArgs
 *                 {
 *                     ServiceName = "S3",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewAssessment(ctx, "test", &auditmanager.AssessmentArgs{
 * 			Name: pulumi.String("example"),
 * 			AssessmentReportsDestination: &auditmanager.AssessmentAssessmentReportsDestinationArgs{
 * 				Destination:     pulumi.Sprintf("s3://%v", testAwsS3Bucket.Id),
 * 				DestinationType: pulumi.String("S3"),
 * 			},
 * 			FrameworkId: pulumi.Any(testAwsAuditmanagerFramework.Id),
 * 			Roles: auditmanager.AssessmentRoleArray{
 * 				&auditmanager.AssessmentRoleArgs{
 * 					RoleArn:  pulumi.Any(testAwsIamRole.Arn),
 * 					RoleType: pulumi.String("PROCESS_OWNER"),
 * 				},
 * 			},
 * 			Scope: &auditmanager.AssessmentScopeArgs{
 * 				AwsAccounts: auditmanager.AssessmentScopeAwsAccountArray{
 * 					&auditmanager.AssessmentScopeAwsAccountArgs{
 * 						Id: pulumi.Any(current.AccountId),
 * 					},
 * 				},
 * 				AwsServices: auditmanager.AssessmentScopeAwsServiceArray{
 * 					&auditmanager.AssessmentScopeAwsServiceArgs{
 * 						ServiceName: pulumi.String("S3"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Assessment;
 * import com.pulumi.aws.auditmanager.AssessmentArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentAssessmentReportsDestinationArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentRoleArgs;
 * import com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Assessment("test", AssessmentArgs.builder()
 *             .name("example")
 *             .assessmentReportsDestination(AssessmentAssessmentReportsDestinationArgs.builder()
 *                 .destination(String.format("s3://%s", testAwsS3Bucket.id()))
 *                 .destinationType("S3")
 *                 .build())
 *             .frameworkId(testAwsAuditmanagerFramework.id())
 *             .roles(AssessmentRoleArgs.builder()
 *                 .roleArn(testAwsIamRole.arn())
 *                 .roleType("PROCESS_OWNER")
 *                 .build())
 *             .scope(AssessmentScopeArgs.builder()
 *                 .awsAccounts(AssessmentScopeAwsAccountArgs.builder()
 *                     .id(current.accountId())
 *                     .build())
 *                 .awsServices(AssessmentScopeAwsServiceArgs.builder()
 *                     .serviceName("S3")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:auditmanager:Assessment
 *     properties:
 *       name: example
 *       assessmentReportsDestination:
 *         destination: s3://${testAwsS3Bucket.id}
 *         destinationType: S3
 *       frameworkId: ${testAwsAuditmanagerFramework.id}
 *       roles:
 *         - roleArn: ${testAwsIamRole.arn}
 *           roleType: PROCESS_OWNER
 *       scope:
 *         awsAccounts:
 *           - id: ${current.accountId}
 *         awsServices:
 *           - serviceName: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessments using the assessment `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/assessment:Assessment example abc123-de45
 * ```
 * @property assessmentReportsDestination Assessment report storage destination configuration. See `assessment_reports_destination` below.
 * @property description Description of the assessment.
 * @property frameworkId Unique identifier of the framework the assessment will be created from.
 * @property name Name of the assessment.
 * @property roles List of roles for the assessment. See `roles` below.
 * @property scope Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class AssessmentArgs(
    public val assessmentReportsDestination: Output<AssessmentAssessmentReportsDestinationArgs>? =
        null,
    public val description: Output<String>? = null,
    public val frameworkId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val roles: Output<List<AssessmentRoleArgs>>? = null,
    public val scope: Output<AssessmentScopeArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AssessmentArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AssessmentArgs =
        com.pulumi.aws.auditmanager.AssessmentArgs.builder()
            .assessmentReportsDestination(
                assessmentReportsDestination?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .frameworkId(frameworkId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .scope(scope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssessmentArgs].
 */
@PulumiTagMarker
public class AssessmentArgsBuilder internal constructor() {
    private var assessmentReportsDestination: Output<AssessmentAssessmentReportsDestinationArgs>? =
        null

    private var description: Output<String>? = null

    private var frameworkId: Output<String>? = null

    private var name: Output<String>? = null

    private var roles: Output<List<AssessmentRoleArgs>>? = null

    private var scope: Output<AssessmentScopeArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("rhpkrelwrcyvbblj")
    public suspend fun assessmentReportsDestination(`value`: Output<AssessmentAssessmentReportsDestinationArgs>) {
        this.assessmentReportsDestination = value
    }

    /**
     * @param value Description of the assessment.
     */
    @JvmName("qvibokdijelxeqfj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier of the framework the assessment will be created from.
     */
    @JvmName("ewbyfiqmelvygawx")
    public suspend fun frameworkId(`value`: Output<String>) {
        this.frameworkId = value
    }

    /**
     * @param value Name of the assessment.
     */
    @JvmName("xoeoliyuxeaobxyy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value List of roles for the assessment. See `roles` below.
     */
    @JvmName("eerirsyrxwvsiiry")
    public suspend fun roles(`value`: Output<List<AssessmentRoleArgs>>) {
        this.roles = value
    }

    @JvmName("qxfcrtoqqmpnikhk")
    public suspend fun roles(vararg values: Output<AssessmentRoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values List of roles for the assessment. See `roles` below.
     */
    @JvmName("eldkbowaladfyogk")
    public suspend fun roles(values: List<Output<AssessmentRoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("kefumnciurjgcudc")
    public suspend fun scope(`value`: Output<AssessmentScopeArgs>) {
        this.scope = value
    }

    /**
     * @param value A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yeuxqkvubrgusdkn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("dohojsogbbxyiacy")
    public suspend fun assessmentReportsDestination(`value`: AssessmentAssessmentReportsDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentReportsDestination = mapped
    }

    /**
     * @param argument Assessment report storage destination configuration. See `assessment_reports_destination` below.
     */
    @JvmName("xkxxpnepwdvkxmyr")
    public suspend fun assessmentReportsDestination(argument: suspend AssessmentAssessmentReportsDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentAssessmentReportsDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.assessmentReportsDestination = mapped
    }

    /**
     * @param value Description of the assessment.
     */
    @JvmName("tpxjihhxvkayjkkg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier of the framework the assessment will be created from.
     */
    @JvmName("kkhvsnnduhqdjcrb")
    public suspend fun frameworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameworkId = mapped
    }

    /**
     * @param value Name of the assessment.
     */
    @JvmName("lefyvayoaqywcesx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value List of roles for the assessment. See `roles` below.
     */
    @JvmName("ennacegqebcdikav")
    public suspend fun roles(`value`: List<AssessmentRoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("icopmvvlawecysxu")
    public suspend fun roles(argument: List<suspend AssessmentRoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("ootuyjawgedutlnu")
    public suspend fun roles(vararg argument: suspend AssessmentRoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssessmentRoleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument List of roles for the assessment. See `roles` below.
     */
    @JvmName("sxaexeoovophjdue")
    public suspend fun roles(argument: suspend AssessmentRoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AssessmentRoleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values List of roles for the assessment. See `roles` below.
     */
    @JvmName("unpipqqsdohispnj")
    public suspend fun roles(vararg values: AssessmentRoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param value Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("amnmhcilybkbefuo")
    public suspend fun scope(`value`: AssessmentScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    /**
     * @param argument Amazon Web Services accounts and services that are in scope for the assessment. See `scope` below.
     * The following arguments are optional:
     */
    @JvmName("nijjvjyxxifvertv")
    public suspend fun scope(argument: suspend AssessmentScopeArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentScopeArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scope = mapped
    }

    /**
     * @param value A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqpeohheqmgrbkic")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the assessment. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ogpfvmwgcgjmmosg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssessmentArgs = AssessmentArgs(
        assessmentReportsDestination = assessmentReportsDestination,
        description = description,
        frameworkId = frameworkId,
        name = name,
        roles = roles,
        scope = scope,
        tags = tags,
    )
}
