@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AssessmentDelegationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Assessment Delegation.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.AssessmentDelegation("example", {
 *     assessmentId: exampleAwsAuditmanagerAssessment.id,
 *     roleArn: exampleAwsIamRole.arn,
 *     roleType: "RESOURCE_OWNER",
 *     controlSetId: "example",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.AssessmentDelegation("example",
 *     assessment_id=example_aws_auditmanager_assessment["id"],
 *     role_arn=example_aws_iam_role["arn"],
 *     role_type="RESOURCE_OWNER",
 *     control_set_id="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.AssessmentDelegation("example", new()
 *     {
 *         AssessmentId = exampleAwsAuditmanagerAssessment.Id,
 *         RoleArn = exampleAwsIamRole.Arn,
 *         RoleType = "RESOURCE_OWNER",
 *         ControlSetId = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewAssessmentDelegation(ctx, "example", &auditmanager.AssessmentDelegationArgs{
 * 			AssessmentId: pulumi.Any(exampleAwsAuditmanagerAssessment.Id),
 * 			RoleArn:      pulumi.Any(exampleAwsIamRole.Arn),
 * 			RoleType:     pulumi.String("RESOURCE_OWNER"),
 * 			ControlSetId: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentDelegation;
 * import com.pulumi.aws.auditmanager.AssessmentDelegationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AssessmentDelegation("example", AssessmentDelegationArgs.builder()
 *             .assessmentId(exampleAwsAuditmanagerAssessment.id())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .roleType("RESOURCE_OWNER")
 *             .controlSetId("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:AssessmentDelegation
 *     properties:
 *       assessmentId: ${exampleAwsAuditmanagerAssessment.id}
 *       roleArn: ${exampleAwsIamRole.arn}
 *       roleType: RESOURCE_OWNER
 *       controlSetId: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessment Delegation using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/assessmentDelegation:AssessmentDelegation example abcdef-123456,arn:aws:iam::012345678901:role/example,example
 * ```
 * @property assessmentId Identifier for the assessment.
 * @property comment Comment describing the delegation request.
 * @property controlSetId Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
 * @property roleArn Amazon Resource Name (ARN) of the IAM role.
 * @property roleType Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
 * The following arguments are optional:
 */
public data class AssessmentDelegationArgs(
    public val assessmentId: Output<String>? = null,
    public val comment: Output<String>? = null,
    public val controlSetId: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val roleType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AssessmentDelegationArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AssessmentDelegationArgs =
        com.pulumi.aws.auditmanager.AssessmentDelegationArgs.builder()
            .assessmentId(assessmentId?.applyValue({ args0 -> args0 }))
            .comment(comment?.applyValue({ args0 -> args0 }))
            .controlSetId(controlSetId?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .roleType(roleType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentDelegationArgs].
 */
@PulumiTagMarker
public class AssessmentDelegationArgsBuilder internal constructor() {
    private var assessmentId: Output<String>? = null

    private var comment: Output<String>? = null

    private var controlSetId: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var roleType: Output<String>? = null

    /**
     * @param value Identifier for the assessment.
     */
    @JvmName("oupsinowimwtrhuw")
    public suspend fun assessmentId(`value`: Output<String>) {
        this.assessmentId = value
    }

    /**
     * @param value Comment describing the delegation request.
     */
    @JvmName("qqtbxxojueapmycb")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
     */
    @JvmName("rmtluguscxgwsher")
    public suspend fun controlSetId(`value`: Output<String>) {
        this.controlSetId = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role.
     */
    @JvmName("onrefhkqikgitsrs")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
     * The following arguments are optional:
     */
    @JvmName("ibevyxyvcmvwbcfy")
    public suspend fun roleType(`value`: Output<String>) {
        this.roleType = value
    }

    /**
     * @param value Identifier for the assessment.
     */
    @JvmName("kokthmsrmgyexahm")
    public suspend fun assessmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentId = mapped
    }

    /**
     * @param value Comment describing the delegation request.
     */
    @JvmName("mgovdvgnuydhdnwf")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Assessment control set name. This value is the control set name used during assessment creation (not the AWS-generated ID). The `_id` suffix on this attribute has been preserved to be consistent with the underlying AWS API.
     */
    @JvmName("krxrtfojbbfnrpvf")
    public suspend fun controlSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlSetId = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM role.
     */
    @JvmName("tbwusmvnbfnivncr")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Type of customer persona. For assessment delegation, type must always be `RESOURCE_OWNER`.
     * The following arguments are optional:
     */
    @JvmName("oxssbofcegreqqpj")
    public suspend fun roleType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleType = mapped
    }

    internal fun build(): AssessmentDelegationArgs = AssessmentDelegationArgs(
        assessmentId = assessmentId,
        comment = comment,
        controlSetId = controlSetId,
        roleArn = roleArn,
        roleType = roleType,
    )
}
