@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AssessmentReportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Assessment Report.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.auditmanager.AssessmentReport("test", {
 *     name: "example",
 *     assessmentId: testAwsAuditmanagerAssessment.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.auditmanager.AssessmentReport("test",
 *     name="example",
 *     assessment_id=test_aws_auditmanager_assessment["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Auditmanager.AssessmentReport("test", new()
 *     {
 *         Name = "example",
 *         AssessmentId = testAwsAuditmanagerAssessment.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewAssessmentReport(ctx, "test", &auditmanager.AssessmentReportArgs{
 * 			Name:         pulumi.String("example"),
 * 			AssessmentId: pulumi.Any(testAwsAuditmanagerAssessment.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.AssessmentReport;
 * import com.pulumi.aws.auditmanager.AssessmentReportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new AssessmentReport("test", AssessmentReportArgs.builder()
 *             .name("example")
 *             .assessmentId(testAwsAuditmanagerAssessment.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:auditmanager:AssessmentReport
 *     properties:
 *       name: example
 *       assessmentId: ${testAwsAuditmanagerAssessment.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Assessment Reports using the assessment report `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/assessmentReport:AssessmentReport example abc123-de45
 * ```
 * @property assessmentId Unique identifier of the assessment to create the report from.
 * The following arguments are optional:
 * @property description Description of the assessment report.
 * @property name Name of the assessment report.
 */
public data class AssessmentReportArgs(
    public val assessmentId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.AssessmentReportArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.AssessmentReportArgs =
        com.pulumi.aws.auditmanager.AssessmentReportArgs.builder()
            .assessmentId(assessmentId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssessmentReportArgs].
 */
@PulumiTagMarker
public class AssessmentReportArgsBuilder internal constructor() {
    private var assessmentId: Output<String>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value Unique identifier of the assessment to create the report from.
     * The following arguments are optional:
     */
    @JvmName("hjfuvvioqcqrfijc")
    public suspend fun assessmentId(`value`: Output<String>) {
        this.assessmentId = value
    }

    /**
     * @param value Description of the assessment report.
     */
    @JvmName("hlfvsfmsssxjryhv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the assessment report.
     */
    @JvmName("kprcvxaurrdjkysg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Unique identifier of the assessment to create the report from.
     * The following arguments are optional:
     */
    @JvmName("qfptmdleqirrsdnd")
    public suspend fun assessmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentId = mapped
    }

    /**
     * @param value Description of the assessment report.
     */
    @JvmName("iefcvhudxgruvyfx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the assessment report.
     */
    @JvmName("idjgtvnswggujdtp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): AssessmentReportArgs = AssessmentReportArgs(
        assessmentId = assessmentId,
        description = description,
        name = name,
    )
}
