@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.AuditmanagerFunctions.getControlPlain
import com.pulumi.aws.auditmanager.AuditmanagerFunctions.getFrameworkPlain
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlControlMappingSource
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlPlainArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.GetControlPlainArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkControlSet
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkPlainArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.GetFrameworkPlainArgsBuilder
import com.pulumi.aws.auditmanager.kotlin.outputs.GetControlResult
import com.pulumi.aws.auditmanager.kotlin.outputs.GetFrameworkResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.auditmanager.kotlin.outputs.GetControlResult.Companion.toKotlin as getControlResultToKotlin
import com.pulumi.aws.auditmanager.kotlin.outputs.GetFrameworkResult.Companion.toKotlin as getFrameworkResultToKotlin

public object AuditmanagerFunctions {
    /**
     * Data source for managing an AWS Audit Manager Control.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.auditmanager.getControl({
     *     name: "1. Risk Management",
     *     type: "Standard",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.auditmanager.get_control(name="1. Risk Management",
     *     type="Standard")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Auditmanager.GetControl.Invoke(new()
     *     {
     *         Name = "1. Risk Management",
     *         Type = "Standard",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := auditmanager.LookupControl(ctx, &auditmanager.LookupControlArgs{
     * 			Name: "1. Risk Management",
     * 			Type: "Standard",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetControlArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("1. Risk Management")
     *             .type("Standard")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:auditmanager:getControl
     *       Arguments:
     *         name: 1. Risk Management
     *         type: Standard
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With Framework Resource
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.auditmanager.getControl({
     *     name: "1. Risk Management",
     *     type: "Standard",
     * });
     * const example2 = aws.auditmanager.getControl({
     *     name: "2. Personnel",
     *     type: "Standard",
     * });
     * const exampleFramework = new aws.auditmanager.Framework("example", {
     *     name: "example",
     *     controlSets: [
     *         {
     *             name: "example",
     *             controls: [{
     *                 id: example.then(example => example.id),
     *             }],
     *         },
     *         {
     *             name: "example2",
     *             controls: [{
     *                 id: example2.then(example2 => example2.id),
     *             }],
     *         },
     *     ],
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.auditmanager.get_control(name="1. Risk Management",
     *     type="Standard")
     * example2 = aws.auditmanager.get_control(name="2. Personnel",
     *     type="Standard")
     * example_framework = aws.auditmanager.Framework("example",
     *     name="example",
     *     control_sets=[
     *         {
     *             "name": "example",
     *             "controls": [{
     *                 "id": example.id,
     *             }],
     *         },
     *         {
     *             "name": "example2",
     *             "controls": [{
     *                 "id": example2.id,
     *             }],
     *         },
     *     ])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Auditmanager.GetControl.Invoke(new()
     *     {
     *         Name = "1. Risk Management",
     *         Type = "Standard",
     *     });
     *     var example2 = Aws.Auditmanager.GetControl.Invoke(new()
     *     {
     *         Name = "2. Personnel",
     *         Type = "Standard",
     *     });
     *     var exampleFramework = new Aws.Auditmanager.Framework("example", new()
     *     {
     *         Name = "example",
     *         ControlSets = new[]
     *         {
     *             new Aws.Auditmanager.Inputs.FrameworkControlSetArgs
     *             {
     *                 Name = "example",
     *                 Controls = new[]
     *                 {
     *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
     *                     {
     *                         Id = example.Apply(getControlResult => getControlResult.Id),
     *                     },
     *                 },
     *             },
     *             new Aws.Auditmanager.Inputs.FrameworkControlSetArgs
     *             {
     *                 Name = "example2",
     *                 Controls = new[]
     *                 {
     *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
     *                     {
     *                         Id = example2.Apply(getControlResult => getControlResult.Id),
     *                     },
     *                 },
     *             },
     *         },
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := auditmanager.LookupControl(ctx, &auditmanager.LookupControlArgs{
     * 			Name: "1. Risk Management",
     * 			Type: "Standard",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		example2, err := auditmanager.LookupControl(ctx, &auditmanager.LookupControlArgs{
     * 			Name: "2. Personnel",
     * 			Type: "Standard",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = auditmanager.NewFramework(ctx, "example", &auditmanager.FrameworkArgs{
     * 			Name: pulumi.String("example"),
     * 			ControlSets: auditmanager.FrameworkControlSetArray{
     * 				&auditmanager.FrameworkControlSetArgs{
     * 					Name: pulumi.String("example"),
     * 					Controls: auditmanager.FrameworkControlSetControlArray{
     * 						&auditmanager.FrameworkControlSetControlArgs{
     * 							Id: pulumi.String(example.Id),
     * 						},
     * 					},
     * 				},
     * 				&auditmanager.FrameworkControlSetArgs{
     * 					Name: pulumi.String("example2"),
     * 					Controls: auditmanager.FrameworkControlSetControlArray{
     * 						&auditmanager.FrameworkControlSetControlArgs{
     * 							Id: pulumi.String(example2.Id),
     * 						},
     * 					},
     * 				},
     * 			},
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetControlArgs;
     * import com.pulumi.aws.auditmanager.Framework;
     * import com.pulumi.aws.auditmanager.FrameworkArgs;
     * import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("1. Risk Management")
     *             .type("Standard")
     *             .build());
     *         final var example2 = AuditmanagerFunctions.getControl(GetControlArgs.builder()
     *             .name("2. Personnel")
     *             .type("Standard")
     *             .build());
     *         var exampleFramework = new Framework("exampleFramework", FrameworkArgs.builder()
     *             .name("example")
     *             .controlSets(
     *                 FrameworkControlSetArgs.builder()
     *                     .name("example")
     *                     .controls(FrameworkControlSetControlArgs.builder()
     *                         .id(example.applyValue(getControlResult -> getControlResult.id()))
     *                         .build())
     *                     .build(),
     *                 FrameworkControlSetArgs.builder()
     *                     .name("example2")
     *                     .controls(FrameworkControlSetControlArgs.builder()
     *                         .id(example2.applyValue(getControlResult -> getControlResult.id()))
     *                         .build())
     *                     .build())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   exampleFramework:
     *     type: aws:auditmanager:Framework
     *     name: example
     *     properties:
     *       name: example
     *       controlSets:
     *         - name: example
     *           controls:
     *             - id: ${example.id}
     *         - name: example2
     *           controls:
     *             - id: ${example2.id}
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:auditmanager:getControl
     *       Arguments:
     *         name: 1. Risk Management
     *         type: Standard
     *   example2:
     *     fn::invoke:
     *       Function: aws:auditmanager:getControl
     *       Arguments:
     *         name: 2. Personnel
     *         type: Standard
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getControl.
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(argument: GetControlPlainArgs): GetControlResult =
        getControlResultToKotlin(getControlPlain(argument.toJava()).await())

    /**
     * @see [getControl].
     * @param controlMappingSources
     * @param name Name of the control.
     * @param type Type of control. Valid values are `Custom` and `Standard`.
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(
        controlMappingSources: List<GetControlControlMappingSource>? = null,
        name: String,
        type: String,
    ): GetControlResult {
        val argument = GetControlPlainArgs(
            controlMappingSources = controlMappingSources,
            name = name,
            type = type,
        )
        return getControlResultToKotlin(getControlPlain(argument.toJava()).await())
    }

    /**
     * @see [getControl].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;auditmanager&#46;kotlin&#46;inputs&#46;GetControlPlainArgs].
     * @return A collection of values returned by getControl.
     */
    public suspend fun getControl(argument: suspend GetControlPlainArgsBuilder.() -> Unit): GetControlResult {
        val builder = GetControlPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getControlResultToKotlin(getControlPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS Audit Manager Framework.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.auditmanager.getFramework({
     *     name: "Essential Eight",
     *     frameworkType: "Standard",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.auditmanager.get_framework(name="Essential Eight",
     *     framework_type="Standard")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Auditmanager.GetFramework.Invoke(new()
     *     {
     *         Name = "Essential Eight",
     *         FrameworkType = "Standard",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := auditmanager.LookupFramework(ctx, &auditmanager.LookupFrameworkArgs{
     * 			Name:          "Essential Eight",
     * 			FrameworkType: "Standard",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.auditmanager.AuditmanagerFunctions;
     * import com.pulumi.aws.auditmanager.inputs.GetFrameworkArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = AuditmanagerFunctions.getFramework(GetFrameworkArgs.builder()
     *             .name("Essential Eight")
     *             .frameworkType("Standard")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:auditmanager:getFramework
     *       Arguments:
     *         name: Essential Eight
     *         frameworkType: Standard
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getFramework.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: GetFrameworkPlainArgs): GetFrameworkResult =
        getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())

    /**
     * @see [getFramework].
     * @param controlSets
     * @param frameworkType
     * @param name Name of the framework.
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(
        controlSets: List<GetFrameworkControlSet>? = null,
        frameworkType: String,
        name: String,
    ): GetFrameworkResult {
        val argument = GetFrameworkPlainArgs(
            controlSets = controlSets,
            frameworkType = frameworkType,
            name = name,
        )
        return getFrameworkResultToKotlin(getFrameworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getFramework].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;auditmanager&#46;kotlin&#46;inputs&#46;GetFrameworkPlainArgs].
     * @return A collection of values returned by getFramework.
     */
    public suspend fun getFramework(argument: suspend GetFrameworkPlainArgsBuilder.() -> Unit): GetFrameworkResult {
        val builder = GetFrameworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFrameworkResultToKotlin(getFrameworkPlain(builtArgument.toJava()).await())
    }
}
