@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.ControlArgs.builder
import com.pulumi.aws.auditmanager.kotlin.inputs.ControlControlMappingSourceArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.ControlControlMappingSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Control.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.Control("example", {
 *     name: "example",
 *     controlMappingSources: [{
 *         sourceName: "example",
 *         sourceSetUpOption: "Procedural_Controls_Mapping",
 *         sourceType: "MANUAL",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.Control("example",
 *     name="example",
 *     control_mapping_sources=[{
 *         "source_name": "example",
 *         "source_set_up_option": "Procedural_Controls_Mapping",
 *         "source_type": "MANUAL",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.Control("example", new()
 *     {
 *         Name = "example",
 *         ControlMappingSources = new[]
 *         {
 *             new Aws.Auditmanager.Inputs.ControlControlMappingSourceArgs
 *             {
 *                 SourceName = "example",
 *                 SourceSetUpOption = "Procedural_Controls_Mapping",
 *                 SourceType = "MANUAL",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewControl(ctx, "example", &auditmanager.ControlArgs{
 * 			Name: pulumi.String("example"),
 * 			ControlMappingSources: auditmanager.ControlControlMappingSourceArray{
 * 				&auditmanager.ControlControlMappingSourceArgs{
 * 					SourceName:        pulumi.String("example"),
 * 					SourceSetUpOption: pulumi.String("Procedural_Controls_Mapping"),
 * 					SourceType:        pulumi.String("MANUAL"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Control;
 * import com.pulumi.aws.auditmanager.ControlArgs;
 * import com.pulumi.aws.auditmanager.inputs.ControlControlMappingSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Control("example", ControlArgs.builder()
 *             .name("example")
 *             .controlMappingSources(ControlControlMappingSourceArgs.builder()
 *                 .sourceName("example")
 *                 .sourceSetUpOption("Procedural_Controls_Mapping")
 *                 .sourceType("MANUAL")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:Control
 *     properties:
 *       name: example
 *       controlMappingSources:
 *         - sourceName: example
 *           sourceSetUpOption: Procedural_Controls_Mapping
 *           sourceType: MANUAL
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an Audit Manager Control using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/control:Control example abc123-de45
 * ```
 * @property actionPlanInstructions Recommended actions to carry out if the control isn't fulfilled.
 * @property actionPlanTitle Title of the action plan for remediating the control.
 * @property controlMappingSources Data mapping sources. See `control_mapping_sources` below.
 * The following arguments are optional:
 * @property description Description of the control.
 * @property name Name of the control.
 * @property tags A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property testingInformation Steps to follow to determine if the control is satisfied.
 */
public data class ControlArgs(
    public val actionPlanInstructions: Output<String>? = null,
    public val actionPlanTitle: Output<String>? = null,
    public val controlMappingSources: Output<List<ControlControlMappingSourceArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val testingInformation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.ControlArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.ControlArgs =
        com.pulumi.aws.auditmanager.ControlArgs.builder()
            .actionPlanInstructions(actionPlanInstructions?.applyValue({ args0 -> args0 }))
            .actionPlanTitle(actionPlanTitle?.applyValue({ args0 -> args0 }))
            .controlMappingSources(
                controlMappingSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .testingInformation(testingInformation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlArgs].
 */
@PulumiTagMarker
public class ControlArgsBuilder internal constructor() {
    private var actionPlanInstructions: Output<String>? = null

    private var actionPlanTitle: Output<String>? = null

    private var controlMappingSources: Output<List<ControlControlMappingSourceArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var testingInformation: Output<String>? = null

    /**
     * @param value Recommended actions to carry out if the control isn't fulfilled.
     */
    @JvmName("qphheiawaeovvafb")
    public suspend fun actionPlanInstructions(`value`: Output<String>) {
        this.actionPlanInstructions = value
    }

    /**
     * @param value Title of the action plan for remediating the control.
     */
    @JvmName("ujhvudtyafvxjvdg")
    public suspend fun actionPlanTitle(`value`: Output<String>) {
        this.actionPlanTitle = value
    }

    /**
     * @param value Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("gkomfurckuwxvuvd")
    public suspend fun controlMappingSources(`value`: Output<List<ControlControlMappingSourceArgs>>) {
        this.controlMappingSources = value
    }

    @JvmName("nutinwqepmndgheb")
    public suspend fun controlMappingSources(vararg values: Output<ControlControlMappingSourceArgs>) {
        this.controlMappingSources = Output.all(values.asList())
    }

    /**
     * @param values Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("juycjjhldyhetmle")
    public suspend fun controlMappingSources(values: List<Output<ControlControlMappingSourceArgs>>) {
        this.controlMappingSources = Output.all(values)
    }

    /**
     * @param value Description of the control.
     */
    @JvmName("rqvlimsisulgubyr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the control.
     */
    @JvmName("cnnyiaeqvwlovxvx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qkattwkfncrxxsjr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Steps to follow to determine if the control is satisfied.
     */
    @JvmName("ovrmpatapgrlctxy")
    public suspend fun testingInformation(`value`: Output<String>) {
        this.testingInformation = value
    }

    /**
     * @param value Recommended actions to carry out if the control isn't fulfilled.
     */
    @JvmName("yubojyhkaybtxwwf")
    public suspend fun actionPlanInstructions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPlanInstructions = mapped
    }

    /**
     * @param value Title of the action plan for remediating the control.
     */
    @JvmName("hqmavohblkltprcl")
    public suspend fun actionPlanTitle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionPlanTitle = mapped
    }

    /**
     * @param value Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("wcjrnibmabjhnpnj")
    public suspend fun controlMappingSources(`value`: List<ControlControlMappingSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("cwfrhpittmvebttl")
    public suspend fun controlMappingSources(argument: List<suspend ControlControlMappingSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ControlControlMappingSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("ltinicfodmjkvyww")
    public suspend fun controlMappingSources(vararg argument: suspend ControlControlMappingSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ControlControlMappingSourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param argument Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("kfwfutvnrqiaqhvb")
    public suspend fun controlMappingSources(argument: suspend ControlControlMappingSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ControlControlMappingSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.controlMappingSources = mapped
    }

    /**
     * @param values Data mapping sources. See `control_mapping_sources` below.
     * The following arguments are optional:
     */
    @JvmName("muphqtntiptguvda")
    public suspend fun controlMappingSources(vararg values: ControlControlMappingSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlMappingSources = mapped
    }

    /**
     * @param value Description of the control.
     */
    @JvmName("ieovclypyfnyfowl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the control.
     */
    @JvmName("uikbsmuacntcttfa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmogscrimadbdjvv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the control. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qyrfycyttrqssqsv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Steps to follow to determine if the control is satisfied.
     */
    @JvmName("jmxkvadjfcynksyp")
    public suspend fun testingInformation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testingInformation = mapped
    }

    internal fun build(): ControlArgs = ControlArgs(
        actionPlanInstructions = actionPlanInstructions,
        actionPlanTitle = actionPlanTitle,
        controlMappingSources = controlMappingSources,
        description = description,
        name = name,
        tags = tags,
        testingInformation = testingInformation,
    )
}
