@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.kotlin.outputs.FrameworkControlSet
import com.pulumi.aws.auditmanager.kotlin.outputs.FrameworkControlSet.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Framework].
 */
@PulumiTagMarker
public class FrameworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FrameworkArgs = FrameworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FrameworkArgsBuilder.() -> Unit) {
        val builder = FrameworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Framework {
        val builtJavaResource = com.pulumi.aws.auditmanager.Framework(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Framework(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Framework.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.auditmanager.Framework("test", {
 *     name: "example",
 *     controlSets: [{
 *         name: "example",
 *         controls: [
 *             {
 *                 id: test1.id,
 *             },
 *             {
 *                 id: test2.id,
 *             },
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.auditmanager.Framework("test",
 *     name="example",
 *     control_sets=[{
 *         "name": "example",
 *         "controls": [
 *             {
 *                 "id": test1["id"],
 *             },
 *             {
 *                 "id": test2["id"],
 *             },
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Auditmanager.Framework("test", new()
 *     {
 *         Name = "example",
 *         ControlSets = new[]
 *         {
 *             new Aws.Auditmanager.Inputs.FrameworkControlSetArgs
 *             {
 *                 Name = "example",
 *                 Controls = new[]
 *                 {
 *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
 *                     {
 *                         Id = test1.Id,
 *                     },
 *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
 *                     {
 *                         Id = test2.Id,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewFramework(ctx, "test", &auditmanager.FrameworkArgs{
 * 			Name: pulumi.String("example"),
 * 			ControlSets: auditmanager.FrameworkControlSetArray{
 * 				&auditmanager.FrameworkControlSetArgs{
 * 					Name: pulumi.String("example"),
 * 					Controls: auditmanager.FrameworkControlSetControlArray{
 * 						&auditmanager.FrameworkControlSetControlArgs{
 * 							Id: pulumi.Any(test1.Id),
 * 						},
 * 						&auditmanager.FrameworkControlSetControlArgs{
 * 							Id: pulumi.Any(test2.Id),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Framework;
 * import com.pulumi.aws.auditmanager.FrameworkArgs;
 * import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Framework("test", FrameworkArgs.builder()
 *             .name("example")
 *             .controlSets(FrameworkControlSetArgs.builder()
 *                 .name("example")
 *                 .controls(
 *                     FrameworkControlSetControlArgs.builder()
 *                         .id(test1.id())
 *                         .build(),
 *                     FrameworkControlSetControlArgs.builder()
 *                         .id(test2.id())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:auditmanager:Framework
 *     properties:
 *       name: example
 *       controlSets:
 *         - name: example
 *           controls:
 *             - id: ${test1.id}
 *             - id: ${test2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Framework using the framework `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/framework:Framework example abc123-de45
 * ```
 */
public class Framework internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.Framework,
) : KotlinCustomResource(javaResource, FrameworkMapper) {
    /**
     * Amazon Resource Name (ARN) of the framework.
     * * `control_sets[*].id` - Unique identifier for the framework control set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
     */
    public val complianceType: Output<String>?
        get() = javaResource.complianceType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    public val controlSets: Output<List<FrameworkControlSet>>?
        get() = javaResource.controlSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Description of the framework.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Framework type, such as a custom framework or a standard framework.
     */
    public val frameworkType: Output<String>
        get() = javaResource.frameworkType().applyValue({ args0 -> args0 })

    /**
     * Name of the framework.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FrameworkMapper : ResourceMapper<Framework> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.Framework::class == javaResource::class

    override fun map(javaResource: Resource): Framework = Framework(
        javaResource as
            com.pulumi.aws.auditmanager.Framework,
    )
}

/**
 * @see [Framework].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Framework].
 */
public suspend fun framework(name: String, block: suspend FrameworkResourceBuilder.() -> Unit): Framework {
    val builder = FrameworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Framework].
 * @param name The _unique_ name of the resulting resource.
 */
public fun framework(name: String): Framework {
    val builder = FrameworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
