@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.FrameworkArgs.builder
import com.pulumi.aws.auditmanager.kotlin.inputs.FrameworkControlSetArgs
import com.pulumi.aws.auditmanager.kotlin.inputs.FrameworkControlSetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Framework.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.auditmanager.Framework("test", {
 *     name: "example",
 *     controlSets: [{
 *         name: "example",
 *         controls: [
 *             {
 *                 id: test1.id,
 *             },
 *             {
 *                 id: test2.id,
 *             },
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.auditmanager.Framework("test",
 *     name="example",
 *     control_sets=[{
 *         "name": "example",
 *         "controls": [
 *             {
 *                 "id": test1["id"],
 *             },
 *             {
 *                 "id": test2["id"],
 *             },
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Auditmanager.Framework("test", new()
 *     {
 *         Name = "example",
 *         ControlSets = new[]
 *         {
 *             new Aws.Auditmanager.Inputs.FrameworkControlSetArgs
 *             {
 *                 Name = "example",
 *                 Controls = new[]
 *                 {
 *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
 *                     {
 *                         Id = test1.Id,
 *                     },
 *                     new Aws.Auditmanager.Inputs.FrameworkControlSetControlArgs
 *                     {
 *                         Id = test2.Id,
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewFramework(ctx, "test", &auditmanager.FrameworkArgs{
 * 			Name: pulumi.String("example"),
 * 			ControlSets: auditmanager.FrameworkControlSetArray{
 * 				&auditmanager.FrameworkControlSetArgs{
 * 					Name: pulumi.String("example"),
 * 					Controls: auditmanager.FrameworkControlSetControlArray{
 * 						&auditmanager.FrameworkControlSetControlArgs{
 * 							Id: pulumi.Any(test1.Id),
 * 						},
 * 						&auditmanager.FrameworkControlSetControlArgs{
 * 							Id: pulumi.Any(test2.Id),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.Framework;
 * import com.pulumi.aws.auditmanager.FrameworkArgs;
 * import com.pulumi.aws.auditmanager.inputs.FrameworkControlSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Framework("test", FrameworkArgs.builder()
 *             .name("example")
 *             .controlSets(FrameworkControlSetArgs.builder()
 *                 .name("example")
 *                 .controls(
 *                     FrameworkControlSetControlArgs.builder()
 *                         .id(test1.id())
 *                         .build(),
 *                     FrameworkControlSetControlArgs.builder()
 *                         .id(test2.id())
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:auditmanager:Framework
 *     properties:
 *       name: example
 *       controlSets:
 *         - name: example
 *           controls:
 *             - id: ${test1.id}
 *             - id: ${test2.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Framework using the framework `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/framework:Framework example abc123-de45
 * ```
 * @property complianceType Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
 * @property controlSets Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
 * The following arguments are optional:
 * @property description Description of the framework.
 * @property name Name of the framework.
 * @property tags A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FrameworkArgs(
    public val complianceType: Output<String>? = null,
    public val controlSets: Output<List<FrameworkControlSetArgs>>? = null,
    public val description: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.FrameworkArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.FrameworkArgs =
        com.pulumi.aws.auditmanager.FrameworkArgs.builder()
            .complianceType(complianceType?.applyValue({ args0 -> args0 }))
            .controlSets(
                controlSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FrameworkArgs].
 */
@PulumiTagMarker
public class FrameworkArgsBuilder internal constructor() {
    private var complianceType: Output<String>? = null

    private var controlSets: Output<List<FrameworkControlSetArgs>>? = null

    private var description: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
     */
    @JvmName("maqtllrcfetglrks")
    public suspend fun complianceType(`value`: Output<String>) {
        this.complianceType = value
    }

    /**
     * @param value Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("resvqprnmgammsjc")
    public suspend fun controlSets(`value`: Output<List<FrameworkControlSetArgs>>) {
        this.controlSets = value
    }

    @JvmName("gnvofttkcipoqswq")
    public suspend fun controlSets(vararg values: Output<FrameworkControlSetArgs>) {
        this.controlSets = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("ddwuwcnxafneorky")
    public suspend fun controlSets(values: List<Output<FrameworkControlSetArgs>>) {
        this.controlSets = Output.all(values)
    }

    /**
     * @param value Description of the framework.
     */
    @JvmName("ariupeyruvimhpur")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of the framework.
     */
    @JvmName("ywkrytstniteewov")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hopnbnnobvulmxwm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Compliance type that the new custom framework supports, such as `CIS` or `HIPAA`.
     */
    @JvmName("ixvbpngretmcqghq")
    public suspend fun complianceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.complianceType = mapped
    }

    /**
     * @param value Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("sfukcmbefrtrcfyg")
    public suspend fun controlSets(`value`: List<FrameworkControlSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlSets = mapped
    }

    /**
     * @param argument Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("wtmgodjmwttnjoek")
    public suspend fun controlSets(argument: List<suspend FrameworkControlSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrameworkControlSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlSets = mapped
    }

    /**
     * @param argument Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("xbhurtyhwuciuslc")
    public suspend fun controlSets(vararg argument: suspend FrameworkControlSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrameworkControlSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.controlSets = mapped
    }

    /**
     * @param argument Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("wcmohjjthlccpuxi")
    public suspend fun controlSets(argument: suspend FrameworkControlSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrameworkControlSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.controlSets = mapped
    }

    /**
     * @param values Configuration block(s) for the control sets that are associated with the framework. See `control_sets` Block below for details.
     * The following arguments are optional:
     */
    @JvmName("cqekycquglnwcagc")
    public suspend fun controlSets(vararg values: FrameworkControlSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.controlSets = mapped
    }

    /**
     * @param value Description of the framework.
     */
    @JvmName("ueaanyytyliddsau")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of the framework.
     */
    @JvmName("hqbcqjgmwekoowws")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kaqtbkkmebltbefg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the framework. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kstntmtwvnyfatxu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FrameworkArgs = FrameworkArgs(
        complianceType = complianceType,
        controlSets = controlSets,
        description = description,
        name = name,
        tags = tags,
    )
}
