@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FrameworkShare].
 */
@PulumiTagMarker
public class FrameworkShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FrameworkShareArgs = FrameworkShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FrameworkShareArgsBuilder.() -> Unit) {
        val builder = FrameworkShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FrameworkShare {
        val builtJavaResource = com.pulumi.aws.auditmanager.FrameworkShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FrameworkShare(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS Audit Manager Framework Share.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.FrameworkShare("example", {
 *     destinationAccount: "012345678901",
 *     destinationRegion: "us-east-1",
 *     frameworkId: exampleAwsAuditmanagerFramework.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.FrameworkShare("example",
 *     destination_account="012345678901",
 *     destination_region="us-east-1",
 *     framework_id=example_aws_auditmanager_framework["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.FrameworkShare("example", new()
 *     {
 *         DestinationAccount = "012345678901",
 *         DestinationRegion = "us-east-1",
 *         FrameworkId = exampleAwsAuditmanagerFramework.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewFrameworkShare(ctx, "example", &auditmanager.FrameworkShareArgs{
 * 			DestinationAccount: pulumi.String("012345678901"),
 * 			DestinationRegion:  pulumi.String("us-east-1"),
 * 			FrameworkId:        pulumi.Any(exampleAwsAuditmanagerFramework.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.FrameworkShare;
 * import com.pulumi.aws.auditmanager.FrameworkShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FrameworkShare("example", FrameworkShareArgs.builder()
 *             .destinationAccount("012345678901")
 *             .destinationRegion("us-east-1")
 *             .frameworkId(exampleAwsAuditmanagerFramework.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:FrameworkShare
 *     properties:
 *       destinationAccount: '012345678901'
 *       destinationRegion: us-east-1
 *       frameworkId: ${exampleAwsAuditmanagerFramework.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Framework Share using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/frameworkShare:FrameworkShare example abcdef-123456
 * ```
 */
public class FrameworkShare internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.FrameworkShare,
) : KotlinCustomResource(javaResource, FrameworkShareMapper) {
    /**
     * Comment from the sender about the share request.
     */
    public val comment: Output<String>?
        get() = javaResource.comment().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Amazon Web Services account of the recipient.
     */
    public val destinationAccount: Output<String>
        get() = javaResource.destinationAccount().applyValue({ args0 -> args0 })

    /**
     * Amazon Web Services region of the recipient.
     */
    public val destinationRegion: Output<String>
        get() = javaResource.destinationRegion().applyValue({ args0 -> args0 })

    /**
     * Unique identifier for the shared custom framework.
     * The following arguments are optional:
     */
    public val frameworkId: Output<String>
        get() = javaResource.frameworkId().applyValue({ args0 -> args0 })

    /**
     * Status of the share request.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object FrameworkShareMapper : ResourceMapper<FrameworkShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.FrameworkShare::class == javaResource::class

    override fun map(javaResource: Resource): FrameworkShare = FrameworkShare(
        javaResource as
            com.pulumi.aws.auditmanager.FrameworkShare,
    )
}

/**
 * @see [FrameworkShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FrameworkShare].
 */
public suspend fun frameworkShare(
    name: String,
    block: suspend FrameworkShareResourceBuilder.() -> Unit,
): FrameworkShare {
    val builder = FrameworkShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FrameworkShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun frameworkShare(name: String): FrameworkShare {
    val builder = FrameworkShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
