@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.aws.auditmanager.FrameworkShareArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS Audit Manager Framework Share.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.FrameworkShare("example", {
 *     destinationAccount: "012345678901",
 *     destinationRegion: "us-east-1",
 *     frameworkId: exampleAwsAuditmanagerFramework.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.FrameworkShare("example",
 *     destination_account="012345678901",
 *     destination_region="us-east-1",
 *     framework_id=example_aws_auditmanager_framework["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.FrameworkShare("example", new()
 *     {
 *         DestinationAccount = "012345678901",
 *         DestinationRegion = "us-east-1",
 *         FrameworkId = exampleAwsAuditmanagerFramework.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewFrameworkShare(ctx, "example", &auditmanager.FrameworkShareArgs{
 * 			DestinationAccount: pulumi.String("012345678901"),
 * 			DestinationRegion:  pulumi.String("us-east-1"),
 * 			FrameworkId:        pulumi.Any(exampleAwsAuditmanagerFramework.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.FrameworkShare;
 * import com.pulumi.aws.auditmanager.FrameworkShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FrameworkShare("example", FrameworkShareArgs.builder()
 *             .destinationAccount("012345678901")
 *             .destinationRegion("us-east-1")
 *             .frameworkId(exampleAwsAuditmanagerFramework.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:FrameworkShare
 *     properties:
 *       destinationAccount: '012345678901'
 *       destinationRegion: us-east-1
 *       frameworkId: ${exampleAwsAuditmanagerFramework.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Framework Share using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/frameworkShare:FrameworkShare example abcdef-123456
 * ```
 * @property comment Comment from the sender about the share request.
 * @property destinationAccount Amazon Web Services account of the recipient.
 * @property destinationRegion Amazon Web Services region of the recipient.
 * @property frameworkId Unique identifier for the shared custom framework.
 * The following arguments are optional:
 */
public data class FrameworkShareArgs(
    public val comment: Output<String>? = null,
    public val destinationAccount: Output<String>? = null,
    public val destinationRegion: Output<String>? = null,
    public val frameworkId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.FrameworkShareArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.FrameworkShareArgs =
        com.pulumi.aws.auditmanager.FrameworkShareArgs.builder()
            .comment(comment?.applyValue({ args0 -> args0 }))
            .destinationAccount(destinationAccount?.applyValue({ args0 -> args0 }))
            .destinationRegion(destinationRegion?.applyValue({ args0 -> args0 }))
            .frameworkId(frameworkId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrameworkShareArgs].
 */
@PulumiTagMarker
public class FrameworkShareArgsBuilder internal constructor() {
    private var comment: Output<String>? = null

    private var destinationAccount: Output<String>? = null

    private var destinationRegion: Output<String>? = null

    private var frameworkId: Output<String>? = null

    /**
     * @param value Comment from the sender about the share request.
     */
    @JvmName("qqtvstuuydnebptj")
    public suspend fun comment(`value`: Output<String>) {
        this.comment = value
    }

    /**
     * @param value Amazon Web Services account of the recipient.
     */
    @JvmName("wchpttclvwwvvojn")
    public suspend fun destinationAccount(`value`: Output<String>) {
        this.destinationAccount = value
    }

    /**
     * @param value Amazon Web Services region of the recipient.
     */
    @JvmName("wxdfyltthtccttnr")
    public suspend fun destinationRegion(`value`: Output<String>) {
        this.destinationRegion = value
    }

    /**
     * @param value Unique identifier for the shared custom framework.
     * The following arguments are optional:
     */
    @JvmName("mtikjlmfijqptqtj")
    public suspend fun frameworkId(`value`: Output<String>) {
        this.frameworkId = value
    }

    /**
     * @param value Comment from the sender about the share request.
     */
    @JvmName("buojdyoirjtpkwvc")
    public suspend fun comment(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comment = mapped
    }

    /**
     * @param value Amazon Web Services account of the recipient.
     */
    @JvmName("pgcboufvqkiwnxgd")
    public suspend fun destinationAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAccount = mapped
    }

    /**
     * @param value Amazon Web Services region of the recipient.
     */
    @JvmName("saihsembuovdarss")
    public suspend fun destinationRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegion = mapped
    }

    /**
     * @param value Unique identifier for the shared custom framework.
     * The following arguments are optional:
     */
    @JvmName("joqxaodfumbamvwe")
    public suspend fun frameworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameworkId = mapped
    }

    internal fun build(): FrameworkShareArgs = FrameworkShareArgs(
        comment = comment,
        destinationAccount = destinationAccount,
        destinationRegion = destinationRegion,
        frameworkId = frameworkId,
    )
}
