@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationAdminAccountRegistration].
 */
@PulumiTagMarker
public class OrganizationAdminAccountRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationAdminAccountRegistrationArgs =
        OrganizationAdminAccountRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationAdminAccountRegistrationArgsBuilder.() -> Unit) {
        val builder = OrganizationAdminAccountRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationAdminAccountRegistration {
        val builtJavaResource =
            com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationAdminAccountRegistration(builtJavaResource)
    }
}

/**
 * Resource for managing AWS Audit Manager Organization Admin Account Registration.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.auditmanager.OrganizationAdminAccountRegistration("example", {adminAccountId: "012345678901"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.auditmanager.OrganizationAdminAccountRegistration("example", admin_account_id="012345678901")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Auditmanager.OrganizationAdminAccountRegistration("example", new()
 *     {
 *         AdminAccountId = "012345678901",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/auditmanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := auditmanager.NewOrganizationAdminAccountRegistration(ctx, "example", &auditmanager.OrganizationAdminAccountRegistrationArgs{
 * 			AdminAccountId: pulumi.String("012345678901"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration;
 * import com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new OrganizationAdminAccountRegistration("example", OrganizationAdminAccountRegistrationArgs.builder()
 *             .adminAccountId("012345678901")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:auditmanager:OrganizationAdminAccountRegistration
 *     properties:
 *       adminAccountId: '012345678901'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Audit Manager Organization Admin Account Registration using the `id`. For example:
 * ```sh
 * $ pulumi import aws:auditmanager/organizationAdminAccountRegistration:OrganizationAdminAccountRegistration example 012345678901
 * ```
 */
public class OrganizationAdminAccountRegistration internal constructor(
    override val javaResource: com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration,
) : KotlinCustomResource(javaResource, OrganizationAdminAccountRegistrationMapper) {
    /**
     * Identifier for the organization administrator account.
     */
    public val adminAccountId: Output<String>
        get() = javaResource.adminAccountId().applyValue({ args0 -> args0 })

    /**
     * Identifier for the organization.
     */
    public val organizationId: Output<String>
        get() = javaResource.organizationId().applyValue({ args0 -> args0 })
}

public object OrganizationAdminAccountRegistrationMapper :
    ResourceMapper<OrganizationAdminAccountRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationAdminAccountRegistration =
        OrganizationAdminAccountRegistration(
            javaResource as
                com.pulumi.aws.auditmanager.OrganizationAdminAccountRegistration,
        )
}

/**
 * @see [OrganizationAdminAccountRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationAdminAccountRegistration].
 */
public suspend fun organizationAdminAccountRegistration(
    name: String,
    block: suspend OrganizationAdminAccountRegistrationResourceBuilder.() -> Unit,
): OrganizationAdminAccountRegistration {
    val builder = OrganizationAdminAccountRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationAdminAccountRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationAdminAccountRegistration(name: String): OrganizationAdminAccountRegistration {
    val builder = OrganizationAdminAccountRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
