@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property awsAccounts Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
 * @property awsServices Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
 */
public data class AssessmentScopeArgs(
    public val awsAccounts: Output<List<AssessmentScopeAwsAccountArgs>>? = null,
    public val awsServices: Output<List<AssessmentScopeAwsServiceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs =
        com.pulumi.aws.auditmanager.inputs.AssessmentScopeArgs.builder()
            .awsAccounts(
                awsAccounts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .awsServices(
                awsServices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AssessmentScopeArgs].
 */
@PulumiTagMarker
public class AssessmentScopeArgsBuilder internal constructor() {
    private var awsAccounts: Output<List<AssessmentScopeAwsAccountArgs>>? = null

    private var awsServices: Output<List<AssessmentScopeAwsServiceArgs>>? = null

    /**
     * @param value Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("ktevbonrkjhwjduk")
    public suspend fun awsAccounts(`value`: Output<List<AssessmentScopeAwsAccountArgs>>) {
        this.awsAccounts = value
    }

    @JvmName("grgfcxftwdijrlmq")
    public suspend fun awsAccounts(vararg values: Output<AssessmentScopeAwsAccountArgs>) {
        this.awsAccounts = Output.all(values.asList())
    }

    /**
     * @param values Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("eruxexqopatdrtvg")
    public suspend fun awsAccounts(values: List<Output<AssessmentScopeAwsAccountArgs>>) {
        this.awsAccounts = Output.all(values)
    }

    /**
     * @param value Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("pdkvmuvxvqicnwge")
    public suspend fun awsServices(`value`: Output<List<AssessmentScopeAwsServiceArgs>>) {
        this.awsServices = value
    }

    @JvmName("xyrygpvbriuawhuv")
    public suspend fun awsServices(vararg values: Output<AssessmentScopeAwsServiceArgs>) {
        this.awsServices = Output.all(values.asList())
    }

    /**
     * @param values Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("hfpemvwuilftpghq")
    public suspend fun awsServices(values: List<Output<AssessmentScopeAwsServiceArgs>>) {
        this.awsServices = Output.all(values)
    }

    /**
     * @param value Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("ajhkessbwpilvchf")
    public suspend fun awsAccounts(`value`: List<AssessmentScopeAwsAccountArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccounts = mapped
    }

    /**
     * @param argument Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("ohaymsyparwmjqxq")
    public suspend fun awsAccounts(argument: List<suspend AssessmentScopeAwsAccountArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentScopeAwsAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccounts = mapped
    }

    /**
     * @param argument Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("tmyybtjnrenjbucd")
    public suspend fun awsAccounts(vararg argument: suspend AssessmentScopeAwsAccountArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssessmentScopeAwsAccountArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsAccounts = mapped
    }

    /**
     * @param argument Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("legulcdqsspiovkc")
    public suspend fun awsAccounts(argument: suspend AssessmentScopeAwsAccountArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssessmentScopeAwsAccountArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.awsAccounts = mapped
    }

    /**
     * @param values Amazon Web Services accounts that are in scope for the assessment. See `aws_accounts` below.
     */
    @JvmName("mmsrpkjodyhppyyi")
    public suspend fun awsAccounts(vararg values: AssessmentScopeAwsAccountArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsAccounts = mapped
    }

    /**
     * @param value Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("gfxxtcflkexqswuj")
    public suspend fun awsServices(`value`: List<AssessmentScopeAwsServiceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsServices = mapped
    }

    /**
     * @param argument Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("xgkrqidajvobtwwl")
    public suspend fun awsServices(argument: List<suspend AssessmentScopeAwsServiceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AssessmentScopeAwsServiceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsServices = mapped
    }

    /**
     * @param argument Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("wtjnkigtjtbykfow")
    public suspend fun awsServices(vararg argument: suspend AssessmentScopeAwsServiceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AssessmentScopeAwsServiceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.awsServices = mapped
    }

    /**
     * @param argument Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("cusbboolmmdkthoe")
    public suspend fun awsServices(argument: suspend AssessmentScopeAwsServiceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AssessmentScopeAwsServiceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.awsServices = mapped
    }

    /**
     * @param values Amazon Web Services services that are included in the scope of the assessment. See `aws_services` below.
     */
    @JvmName("nayfnbticgatvcgo")
    public suspend fun awsServices(vararg values: AssessmentScopeAwsServiceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.awsServices = mapped
    }

    internal fun build(): AssessmentScopeArgs = AssessmentScopeArgs(
        awsAccounts = awsAccounts,
        awsServices = awsServices,
    )
}
