@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.inputs

import com.pulumi.aws.auditmanager.inputs.GetFrameworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFramework.
 * @property controlSets
 * @property frameworkType
 * @property name Name of the framework.
 */
public data class GetFrameworkPlainArgs(
    public val controlSets: List<GetFrameworkControlSet>? = null,
    public val frameworkType: String,
    public val name: String,
) : ConvertibleToJava<com.pulumi.aws.auditmanager.inputs.GetFrameworkPlainArgs> {
    override fun toJava(): com.pulumi.aws.auditmanager.inputs.GetFrameworkPlainArgs =
        com.pulumi.aws.auditmanager.inputs.GetFrameworkPlainArgs.builder()
            .controlSets(
                controlSets?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .frameworkType(frameworkType.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFrameworkPlainArgs].
 */
@PulumiTagMarker
public class GetFrameworkPlainArgsBuilder internal constructor() {
    private var controlSets: List<GetFrameworkControlSet>? = null

    private var frameworkType: String? = null

    private var name: String? = null

    /**
     * @param value
     */
    @JvmName("leqpaxvfqhfoqkrv")
    public suspend fun controlSets(`value`: List<GetFrameworkControlSet>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.controlSets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xqqhbsgprkchioeh")
    public suspend fun controlSets(argument: List<suspend GetFrameworkControlSetBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetFrameworkControlSetBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controlSets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bjvuhujkqgvducub")
    public suspend fun controlSets(vararg argument: suspend GetFrameworkControlSetBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetFrameworkControlSetBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.controlSets = mapped
    }

    /**
     * @param argument
     */
    @JvmName("fgoftuxmhcqnwhpq")
    public suspend fun controlSets(argument: suspend GetFrameworkControlSetBuilder.() -> Unit) {
        val toBeMapped = listOf(GetFrameworkControlSetBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.controlSets = mapped
    }

    /**
     * @param values
     */
    @JvmName("acbynelvnysomyxo")
    public suspend fun controlSets(vararg values: GetFrameworkControlSet) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.controlSets = mapped
    }

    /**
     * @param value
     */
    @JvmName("pqlelwkmpcdinsnx")
    public suspend fun frameworkType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frameworkType = mapped
    }

    /**
     * @param value Name of the framework.
     */
    @JvmName("qrfvkngqlidanmhp")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    internal fun build(): GetFrameworkPlainArgs = GetFrameworkPlainArgs(
        controlSets = controlSets,
        frameworkType = frameworkType ?: throw PulumiNullFieldException("frameworkType"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
