@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination Destination of the assessment report. This value be in the form `s3://{bucket_name}`.
 * @property destinationType Destination type. Currently, `S3` is the only valid value.
 */
public data class AssessmentAssessmentReportsDestination(
    public val destination: String,
    public val destinationType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.AssessmentAssessmentReportsDestination): AssessmentAssessmentReportsDestination = AssessmentAssessmentReportsDestination(
            destination = javaType.destination(),
            destinationType = javaType.destinationType(),
        )
    }
}
