@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property roleArn Amazon Resource Name (ARN) of the IAM role.
 * @property roleType Type of customer persona. For assessment creation, type must always be `PROCESS_OWNER`.
 */
public data class AssessmentRole(
    public val roleArn: String,
    public val roleType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.AssessmentRole): AssessmentRole = AssessmentRole(
            roleArn = javaType.roleArn(),
            roleType = javaType.roleType(),
        )
    }
}
