@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceDescription Description of the source.
 * @property sourceFrequency Frequency of evidence collection. Valid values are `DAILY`, `WEEKLY`, or `MONTHLY`.
 * @property sourceId
 * @property sourceKeyword The keyword to search for in CloudTrail logs, Config rules, Security Hub checks, and Amazon Web Services API names. See `source_keyword` below.
 * @property sourceName Name of the source.
 * @property sourceSetUpOption The setup option for the data source. This option reflects if the evidence collection is automated or manual. Valid values are `System_Controls_Mapping` (automated) and `Procedural_Controls_Mapping` (manual).
 * @property sourceType Type of data source for evidence collection. If `source_set_up_option` is manual, the only valid value is `MANUAL`. If `source_set_up_option` is automated, valid values are `AWS_Cloudtrail`, `AWS_Config`, `AWS_Security_Hub`, or `AWS_API_Call`.
 * The following arguments are optional:
 * @property troubleshootingText Instructions for troubleshooting the control.
 */
public data class ControlControlMappingSource(
    public val sourceDescription: String? = null,
    public val sourceFrequency: String? = null,
    public val sourceId: String? = null,
    public val sourceKeyword: ControlControlMappingSourceSourceKeyword? = null,
    public val sourceName: String,
    public val sourceSetUpOption: String,
    public val sourceType: String,
    public val troubleshootingText: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.ControlControlMappingSource): ControlControlMappingSource = ControlControlMappingSource(
            sourceDescription = javaType.sourceDescription().map({ args0 -> args0 }).orElse(null),
            sourceFrequency = javaType.sourceFrequency().map({ args0 -> args0 }).orElse(null),
            sourceId = javaType.sourceId().map({ args0 -> args0 }).orElse(null),
            sourceKeyword = javaType.sourceKeyword().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.ControlControlMappingSourceSourceKeyword.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceName = javaType.sourceName(),
            sourceSetUpOption = javaType.sourceSetUpOption(),
            sourceType = javaType.sourceType(),
            troubleshootingText = javaType.troubleshootingText().map({ args0 -> args0 }).orElse(null),
        )
    }
}
