@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property sourceDescription
 * @property sourceFrequency
 * @property sourceId
 * @property sourceKeyword
 * @property sourceName
 * @property sourceSetUpOption
 * @property sourceType
 * @property troubleshootingText
 */
public data class GetControlControlMappingSource(
    public val sourceDescription: String,
    public val sourceFrequency: String,
    public val sourceId: String,
    public val sourceKeyword: GetControlControlMappingSourceSourceKeyword? = null,
    public val sourceName: String,
    public val sourceSetUpOption: String,
    public val sourceType: String,
    public val troubleshootingText: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.GetControlControlMappingSource): GetControlControlMappingSource = GetControlControlMappingSource(
            sourceDescription = javaType.sourceDescription(),
            sourceFrequency = javaType.sourceFrequency(),
            sourceId = javaType.sourceId(),
            sourceKeyword = javaType.sourceKeyword().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.GetControlControlMappingSourceSourceKeyword.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sourceName = javaType.sourceName(),
            sourceSetUpOption = javaType.sourceSetUpOption(),
            sourceType = javaType.sourceType(),
            troubleshootingText = javaType.troubleshootingText(),
        )
    }
}
