@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.auditmanager.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getControl.
 * @property actionPlanInstructions
 * @property actionPlanTitle
 * @property arn
 * @property controlMappingSources
 * @property description
 * @property id
 * @property name
 * @property tags
 * @property testingInformation
 * @property type
 */
public data class GetControlResult(
    public val actionPlanInstructions: String,
    public val actionPlanTitle: String,
    public val arn: String,
    public val controlMappingSources: List<GetControlControlMappingSource>? = null,
    public val description: String,
    public val id: String,
    public val name: String,
    public val tags: Map<String, String>,
    public val testingInformation: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.auditmanager.outputs.GetControlResult): GetControlResult = GetControlResult(
            actionPlanInstructions = javaType.actionPlanInstructions(),
            actionPlanTitle = javaType.actionPlanTitle(),
            arn = javaType.arn(),
            controlMappingSources = javaType.controlMappingSources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.auditmanager.kotlin.outputs.GetControlControlMappingSource.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            testingInformation = javaType.testingInformation(),
            type = javaType.type(),
        )
    }
}
