@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.AttachmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Attaches a load balancer to an Auto Scaling group.
 * > **NOTE on Auto Scaling Groups, Attachments and Traffic Source Attachments:** Pulumi provides standalone Attachment (for attaching Classic Load Balancers and Application Load Balancer, Gateway Load Balancer, or Network Load Balancer target groups) and Traffic Source Attachment (for attaching Load Balancers and VPC Lattice target groups) resources and an Auto Scaling Group resource with `load_balancers`, `target_group_arns` and `traffic_source` attributes. Do not use the same traffic source in more than one of these resources. Doing so will cause a conflict of attachments. A `lifecycle` configuration block can be used to suppress differences if necessary.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new load balancer attachment
 * const example = new aws.autoscaling.Attachment("example", {
 *     autoscalingGroupName: exampleAwsAutoscalingGroup.id,
 *     elb: exampleAwsElb.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new load balancer attachment
 * example = aws.autoscaling.Attachment("example",
 *     autoscaling_group_name=example_aws_autoscaling_group["id"],
 *     elb=example_aws_elb["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new load balancer attachment
 *     var example = new Aws.AutoScaling.Attachment("example", new()
 *     {
 *         AutoscalingGroupName = exampleAwsAutoscalingGroup.Id,
 *         Elb = exampleAwsElb.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new load balancer attachment
 * 		_, err := autoscaling.NewAttachment(ctx, "example", &autoscaling.AttachmentArgs{
 * 			AutoscalingGroupName: pulumi.Any(exampleAwsAutoscalingGroup.Id),
 * 			Elb:                  pulumi.Any(exampleAwsElb.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Attachment;
 * import com.pulumi.aws.autoscaling.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new load balancer attachment
 *         var example = new Attachment("example", AttachmentArgs.builder()
 *             .autoscalingGroupName(exampleAwsAutoscalingGroup.id())
 *             .elb(exampleAwsElb.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new load balancer attachment
 *   example:
 *     type: aws:autoscaling:Attachment
 *     properties:
 *       autoscalingGroupName: ${exampleAwsAutoscalingGroup.id}
 *       elb: ${exampleAwsElb.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * // Create a new ALB Target Group attachment
 * const example = new aws.autoscaling.Attachment("example", {
 *     autoscalingGroupName: exampleAwsAutoscalingGroup.id,
 *     lbTargetGroupArn: exampleAwsLbTargetGroup.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * # Create a new ALB Target Group attachment
 * example = aws.autoscaling.Attachment("example",
 *     autoscaling_group_name=example_aws_autoscaling_group["id"],
 *     lb_target_group_arn=example_aws_lb_target_group["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new ALB Target Group attachment
 *     var example = new Aws.AutoScaling.Attachment("example", new()
 *     {
 *         AutoscalingGroupName = exampleAwsAutoscalingGroup.Id,
 *         LbTargetGroupArn = exampleAwsLbTargetGroup.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new ALB Target Group attachment
 * 		_, err := autoscaling.NewAttachment(ctx, "example", &autoscaling.AttachmentArgs{
 * 			AutoscalingGroupName: pulumi.Any(exampleAwsAutoscalingGroup.Id),
 * 			LbTargetGroupArn:     pulumi.Any(exampleAwsLbTargetGroup.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Attachment;
 * import com.pulumi.aws.autoscaling.AttachmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new ALB Target Group attachment
 *         var example = new Attachment("example", AttachmentArgs.builder()
 *             .autoscalingGroupName(exampleAwsAutoscalingGroup.id())
 *             .lbTargetGroupArn(exampleAwsLbTargetGroup.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new ALB Target Group attachment
 *   example:
 *     type: aws:autoscaling:Attachment
 *     properties:
 *       autoscalingGroupName: ${exampleAwsAutoscalingGroup.id}
 *       lbTargetGroupArn: ${exampleAwsLbTargetGroup.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property autoscalingGroupName Name of ASG to associate with the ELB.
 * @property elb Name of the ELB.
 * @property lbTargetGroupArn ARN of a load balancer target group.
 */
public data class AttachmentArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val elb: Output<String>? = null,
    public val lbTargetGroupArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.AttachmentArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.AttachmentArgs =
        com.pulumi.aws.autoscaling.AttachmentArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .elb(elb?.applyValue({ args0 -> args0 }))
            .lbTargetGroupArn(lbTargetGroupArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AttachmentArgs].
 */
@PulumiTagMarker
public class AttachmentArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var elb: Output<String>? = null

    private var lbTargetGroupArn: Output<String>? = null

    /**
     * @param value Name of ASG to associate with the ELB.
     */
    @JvmName("pmpjyhkjcpiuxdkl")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value Name of the ELB.
     */
    @JvmName("lghoddwavsecxyjm")
    public suspend fun elb(`value`: Output<String>) {
        this.elb = value
    }

    /**
     * @param value ARN of a load balancer target group.
     */
    @JvmName("bijlbrpsqubfiorp")
    public suspend fun lbTargetGroupArn(`value`: Output<String>) {
        this.lbTargetGroupArn = value
    }

    /**
     * @param value Name of ASG to associate with the ELB.
     */
    @JvmName("kcteucgijsubrfts")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value Name of the ELB.
     */
    @JvmName("wlpkninrvhfcgniw")
    public suspend fun elb(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elb = mapped
    }

    /**
     * @param value ARN of a load balancer target group.
     */
    @JvmName("pgawwjfhymyhvict")
    public suspend fun lbTargetGroupArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbTargetGroupArn = mapped
    }

    internal fun build(): AttachmentArgs = AttachmentArgs(
        autoscalingGroupName = autoscalingGroupName,
        elb = elb,
        lbTargetGroupArn = lbTargetGroupArn,
    )
}
