@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.AutoscalingFunctions.getAmiIdsPlain
import com.pulumi.aws.autoscaling.AutoscalingFunctions.getGroupPlain
import com.pulumi.aws.autoscaling.kotlin.inputs.GetAmiIdsFilter
import com.pulumi.aws.autoscaling.kotlin.inputs.GetAmiIdsPlainArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GetAmiIdsPlainArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.inputs.GetGroupPlainArgs
import com.pulumi.aws.autoscaling.kotlin.inputs.GetGroupPlainArgsBuilder
import com.pulumi.aws.autoscaling.kotlin.outputs.GetAmiIdsResult
import com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.autoscaling.kotlin.outputs.GetAmiIdsResult.Companion.toKotlin as getAmiIdsResultToKotlin
import com.pulumi.aws.autoscaling.kotlin.outputs.GetGroupResult.Companion.toKotlin as getGroupResultToKotlin

public object AutoscalingFunctions {
    /**
     * The Autoscaling Groups data source allows access to the list of AWS
     * ASGs within a specific region. This will allow you to pass a list of AutoScaling Groups to other resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const groups = aws.autoscaling.getAmiIds({
     *     filters: [
     *         {
     *             name: "tag:Team",
     *             values: ["Pets"],
     *         },
     *         {
     *             name: "tag-key",
     *             values: ["Environment"],
     *         },
     *     ],
     * });
     * const slackNotifications = new aws.autoscaling.Notification("slack_notifications", {
     *     groupNames: groups.then(groups => groups.names),
     *     notifications: [
     *         "autoscaling:EC2_INSTANCE_LAUNCH",
     *         "autoscaling:EC2_INSTANCE_TERMINATE",
     *         "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
     *         "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
     *     ],
     *     topicArn: "TOPIC ARN",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * groups = aws.autoscaling.get_ami_ids(filters=[
     *     {
     *         "name": "tag:Team",
     *         "values": ["Pets"],
     *     },
     *     {
     *         "name": "tag-key",
     *         "values": ["Environment"],
     *     },
     * ])
     * slack_notifications = aws.autoscaling.Notification("slack_notifications",
     *     group_names=groups.names,
     *     notifications=[
     *         "autoscaling:EC2_INSTANCE_LAUNCH",
     *         "autoscaling:EC2_INSTANCE_TERMINATE",
     *         "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
     *         "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
     *     ],
     *     topic_arn="TOPIC ARN")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var groups = Aws.AutoScaling.GetAmiIds.Invoke(new()
     *     {
     *         Filters = new[]
     *         {
     *             new Aws.AutoScaling.Inputs.GetAmiIdsFilterInputArgs
     *             {
     *                 Name = "tag:Team",
     *                 Values = new[]
     *                 {
     *                     "Pets",
     *                 },
     *             },
     *             new Aws.AutoScaling.Inputs.GetAmiIdsFilterInputArgs
     *             {
     *                 Name = "tag-key",
     *                 Values = new[]
     *                 {
     *                     "Environment",
     *                 },
     *             },
     *         },
     *     });
     *     var slackNotifications = new Aws.AutoScaling.Notification("slack_notifications", new()
     *     {
     *         GroupNames = groups.Apply(getAmiIdsResult => getAmiIdsResult.Names),
     *         Notifications = new[]
     *         {
     *             "autoscaling:EC2_INSTANCE_LAUNCH",
     *             "autoscaling:EC2_INSTANCE_TERMINATE",
     *             "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
     *             "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
     *         },
     *         TopicArn = "TOPIC ARN",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		groups, err := autoscaling.GetAmiIds(ctx, &autoscaling.GetAmiIdsArgs{
     * 			Filters: []autoscaling.GetAmiIdsFilter{
     * 				{
     * 					Name: "tag:Team",
     * 					Values: []string{
     * 						"Pets",
     * 					},
     * 				},
     * 				{
     * 					Name: "tag-key",
     * 					Values: []string{
     * 						"Environment",
     * 					},
     * 				},
     * 			},
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = autoscaling.NewNotification(ctx, "slack_notifications", &autoscaling.NotificationArgs{
     * 			GroupNames: interface{}(groups.Names),
     * 			Notifications: pulumi.StringArray{
     * 				pulumi.String("autoscaling:EC2_INSTANCE_LAUNCH"),
     * 				pulumi.String("autoscaling:EC2_INSTANCE_TERMINATE"),
     * 				pulumi.String("autoscaling:EC2_INSTANCE_LAUNCH_ERROR"),
     * 				pulumi.String("autoscaling:EC2_INSTANCE_TERMINATE_ERROR"),
     * 			},
     * 			TopicArn: pulumi.String("TOPIC ARN"),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.autoscaling.AutoscalingFunctions;
     * import com.pulumi.aws.autoscaling.inputs.GetAmiIdsArgs;
     * import com.pulumi.aws.autoscaling.Notification;
     * import com.pulumi.aws.autoscaling.NotificationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var groups = AutoscalingFunctions.getAmiIds(GetAmiIdsArgs.builder()
     *             .filters(
     *                 GetAmiIdsFilterArgs.builder()
     *                     .name("tag:Team")
     *                     .values("Pets")
     *                     .build(),
     *                 GetAmiIdsFilterArgs.builder()
     *                     .name("tag-key")
     *                     .values("Environment")
     *                     .build())
     *             .build());
     *         var slackNotifications = new Notification("slackNotifications", NotificationArgs.builder()
     *             .groupNames(groups.applyValue(getAmiIdsResult -> getAmiIdsResult.names()))
     *             .notifications(
     *                 "autoscaling:EC2_INSTANCE_LAUNCH",
     *                 "autoscaling:EC2_INSTANCE_TERMINATE",
     *                 "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
     *                 "autoscaling:EC2_INSTANCE_TERMINATE_ERROR")
     *             .topicArn("TOPIC ARN")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   slackNotifications:
     *     type: aws:autoscaling:Notification
     *     name: slack_notifications
     *     properties:
     *       groupNames: ${groups.names}
     *       notifications:
     *         - autoscaling:EC2_INSTANCE_LAUNCH
     *         - autoscaling:EC2_INSTANCE_TERMINATE
     *         - autoscaling:EC2_INSTANCE_LAUNCH_ERROR
     *         - autoscaling:EC2_INSTANCE_TERMINATE_ERROR
     *       topicArn: TOPIC ARN
     * variables:
     *   groups:
     *     fn::invoke:
     *       Function: aws:autoscaling:getAmiIds
     *       Arguments:
     *         filters:
     *           - name: tag:Team
     *             values:
     *               - Pets
     *           - name: tag-key
     *             values:
     *               - Environment
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAmiIds.
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: GetAmiIdsPlainArgs): GetAmiIdsResult =
        getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())

    /**
     * @see [getAmiIds].
     * @param filters Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     * @param names List of autoscaling group names
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(filters: List<GetAmiIdsFilter>? = null, names: List<String>? = null): GetAmiIdsResult {
        val argument = GetAmiIdsPlainArgs(
            filters = filters,
            names = names,
        )
        return getAmiIdsResultToKotlin(getAmiIdsPlain(argument.toJava()).await())
    }

    /**
     * @see [getAmiIds].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;autoscaling&#46;kotlin&#46;inputs&#46;GetAmiIdsPlainArgs].
     * @return A collection of values returned by getAmiIds.
     */
    public suspend fun getAmiIds(argument: suspend GetAmiIdsPlainArgsBuilder.() -> Unit): GetAmiIdsResult {
        val builder = GetAmiIdsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAmiIdsResultToKotlin(getAmiIdsPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get information on an existing autoscaling group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const foo = aws.autoscaling.getGroup({
     *     name: "foo",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * foo = aws.autoscaling.get_group(name="foo")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var foo = Aws.AutoScaling.GetGroup.Invoke(new()
     *     {
     *         Name = "foo",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := autoscaling.LookupGroup(ctx, &autoscaling.LookupGroupArgs{
     * 			Name: "foo",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.autoscaling.AutoscalingFunctions;
     * import com.pulumi.aws.autoscaling.inputs.GetGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var foo = AutoscalingFunctions.getGroup(GetGroupArgs.builder()
     *             .name("foo")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   foo:
     *     fn::invoke:
     *       Function: aws:autoscaling:getGroup
     *       Arguments:
     *         name: foo
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getGroup.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: GetGroupPlainArgs): GetGroupResult =
        getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())

    /**
     * @see [getGroup].
     * @param name Specify the exact name of the desired autoscaling group.
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(name: String): GetGroupResult {
        val argument = GetGroupPlainArgs(
            name = name,
        )
        return getGroupResultToKotlin(getGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;autoscaling&#46;kotlin&#46;inputs&#46;GetGroupPlainArgs].
     * @return A collection of values returned by getGroup.
     */
    public suspend fun getGroup(argument: suspend GetGroupPlainArgsBuilder.() -> Unit): GetGroupResult {
        val builder = GetGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGroupResultToKotlin(getGroupPlain(builtArgument.toJava()).await())
    }
}
