@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.NotificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AutoScaling Group with Notification support, via SNS Topics. Each of
 * the `notifications` map to a [Notification Configuration](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_DescribeNotificationConfigurations.html) inside Amazon Web
 * Services, and are applied to each AutoScaling Group you supply.
 * ## Example Usage
 * Basic usage:
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.sns.Topic("example", {name: "example-topic"});
 * const bar = new aws.autoscaling.Group("bar", {name: "foobar1-test"});
 * const foo = new aws.autoscaling.Group("foo", {name: "barfoo-test"});
 * const exampleNotifications = new aws.autoscaling.Notification("example_notifications", {
 *     groupNames: [
 *         bar.name,
 *         foo.name,
 *     ],
 *     notifications: [
 *         "autoscaling:EC2_INSTANCE_LAUNCH",
 *         "autoscaling:EC2_INSTANCE_TERMINATE",
 *         "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *         "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
 *     ],
 *     topicArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.sns.Topic("example", name="example-topic")
 * bar = aws.autoscaling.Group("bar", name="foobar1-test")
 * foo = aws.autoscaling.Group("foo", name="barfoo-test")
 * example_notifications = aws.autoscaling.Notification("example_notifications",
 *     group_names=[
 *         bar.name,
 *         foo.name,
 *     ],
 *     notifications=[
 *         "autoscaling:EC2_INSTANCE_LAUNCH",
 *         "autoscaling:EC2_INSTANCE_TERMINATE",
 *         "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *         "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
 *     ],
 *     topic_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Sns.Topic("example", new()
 *     {
 *         Name = "example-topic",
 *     });
 *     var bar = new Aws.AutoScaling.Group("bar", new()
 *     {
 *         Name = "foobar1-test",
 *     });
 *     var foo = new Aws.AutoScaling.Group("foo", new()
 *     {
 *         Name = "barfoo-test",
 *     });
 *     var exampleNotifications = new Aws.AutoScaling.Notification("example_notifications", new()
 *     {
 *         GroupNames = new[]
 *         {
 *             bar.Name,
 *             foo.Name,
 *         },
 *         Notifications = new[]
 *         {
 *             "autoscaling:EC2_INSTANCE_LAUNCH",
 *             "autoscaling:EC2_INSTANCE_TERMINATE",
 *             "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *             "autoscaling:EC2_INSTANCE_TERMINATE_ERROR",
 *         },
 *         TopicArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/sns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := sns.NewTopic(ctx, "example", &sns.TopicArgs{
 * 			Name: pulumi.String("example-topic"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		bar, err := autoscaling.NewGroup(ctx, "bar", &autoscaling.GroupArgs{
 * 			Name: pulumi.String("foobar1-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		foo, err := autoscaling.NewGroup(ctx, "foo", &autoscaling.GroupArgs{
 * 			Name: pulumi.String("barfoo-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = autoscaling.NewNotification(ctx, "example_notifications", &autoscaling.NotificationArgs{
 * 			GroupNames: pulumi.StringArray{
 * 				bar.Name,
 * 				foo.Name,
 * 			},
 * 			Notifications: pulumi.StringArray{
 * 				pulumi.String("autoscaling:EC2_INSTANCE_LAUNCH"),
 * 				pulumi.String("autoscaling:EC2_INSTANCE_TERMINATE"),
 * 				pulumi.String("autoscaling:EC2_INSTANCE_LAUNCH_ERROR"),
 * 				pulumi.String("autoscaling:EC2_INSTANCE_TERMINATE_ERROR"),
 * 			},
 * 			TopicArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.sns.Topic;
 * import com.pulumi.aws.sns.TopicArgs;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.Notification;
 * import com.pulumi.aws.autoscaling.NotificationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Topic("example", TopicArgs.builder()
 *             .name("example-topic")
 *             .build());
 *         var bar = new Group("bar", GroupArgs.builder()
 *             .name("foobar1-test")
 *             .build());
 *         var foo = new Group("foo", GroupArgs.builder()
 *             .name("barfoo-test")
 *             .build());
 *         var exampleNotifications = new Notification("exampleNotifications", NotificationArgs.builder()
 *             .groupNames(
 *                 bar.name(),
 *                 foo.name())
 *             .notifications(
 *                 "autoscaling:EC2_INSTANCE_LAUNCH",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE",
 *                 "autoscaling:EC2_INSTANCE_LAUNCH_ERROR",
 *                 "autoscaling:EC2_INSTANCE_TERMINATE_ERROR")
 *             .topicArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleNotifications:
 *     type: aws:autoscaling:Notification
 *     name: example_notifications
 *     properties:
 *       groupNames:
 *         - ${bar.name}
 *         - ${foo.name}
 *       notifications:
 *         - autoscaling:EC2_INSTANCE_LAUNCH
 *         - autoscaling:EC2_INSTANCE_TERMINATE
 *         - autoscaling:EC2_INSTANCE_LAUNCH_ERROR
 *         - autoscaling:EC2_INSTANCE_TERMINATE_ERROR
 *       topicArn: ${example.arn}
 *   example:
 *     type: aws:sns:Topic
 *     properties:
 *       name: example-topic
 *   bar:
 *     type: aws:autoscaling:Group
 *     properties:
 *       name: foobar1-test
 *   foo:
 *     type: aws:autoscaling:Group
 *     properties:
 *       name: barfoo-test
 * ```
 * <!--End PulumiCodeChooser -->
 * @property groupNames List of AutoScaling Group Names
 * @property notifications List of Notification Types that trigger
 * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
 * @property topicArn Topic ARN for notifications to be sent through
 */
public data class NotificationArgs(
    public val groupNames: Output<List<String>>? = null,
    public val notifications: Output<List<String>>? = null,
    public val topicArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.NotificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.NotificationArgs =
        com.pulumi.aws.autoscaling.NotificationArgs.builder()
            .groupNames(groupNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notifications(notifications?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .topicArn(topicArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationArgs].
 */
@PulumiTagMarker
public class NotificationArgsBuilder internal constructor() {
    private var groupNames: Output<List<String>>? = null

    private var notifications: Output<List<String>>? = null

    private var topicArn: Output<String>? = null

    /**
     * @param value List of AutoScaling Group Names
     */
    @JvmName("jpomtcngrrmrsadx")
    public suspend fun groupNames(`value`: Output<List<String>>) {
        this.groupNames = value
    }

    @JvmName("sqgwhfdxtoswjgvj")
    public suspend fun groupNames(vararg values: Output<String>) {
        this.groupNames = Output.all(values.asList())
    }

    /**
     * @param values List of AutoScaling Group Names
     */
    @JvmName("arprhjsaxyxyxuti")
    public suspend fun groupNames(values: List<Output<String>>) {
        this.groupNames = Output.all(values)
    }

    /**
     * @param value List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("cbdxkqmqnjshqcrw")
    public suspend fun notifications(`value`: Output<List<String>>) {
        this.notifications = value
    }

    @JvmName("vjgfxbcasiehrrln")
    public suspend fun notifications(vararg values: Output<String>) {
        this.notifications = Output.all(values.asList())
    }

    /**
     * @param values List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("wmmdhvxwaofxtrym")
    public suspend fun notifications(values: List<Output<String>>) {
        this.notifications = Output.all(values)
    }

    /**
     * @param value Topic ARN for notifications to be sent through
     */
    @JvmName("fqahldkrvlfkiteo")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value List of AutoScaling Group Names
     */
    @JvmName("yhultawdyyjsmfoe")
    public suspend fun groupNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param values List of AutoScaling Group Names
     */
    @JvmName("mqrtkrbyncuscdlv")
    public suspend fun groupNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupNames = mapped
    }

    /**
     * @param value List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("lopgkipcbhuyovek")
    public suspend fun notifications(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param values List of Notification Types that trigger
     * notifications. Acceptable values are documented [in the AWS documentation here](https://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_NotificationConfiguration.html)
     */
    @JvmName("glvsyhrsykdbksyr")
    public suspend fun notifications(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifications = mapped
    }

    /**
     * @param value Topic ARN for notifications to be sent through
     */
    @JvmName("tcxbygsnkvfwrlfx")
    public suspend fun topicArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): NotificationArgs = NotificationArgs(
        groupNames = groupNames,
        notifications = notifications,
        topicArn = topicArn,
    )
}
