@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Schedule].
 */
@PulumiTagMarker
public class ScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ScheduleArgs = ScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ScheduleArgsBuilder.() -> Unit) {
        val builder = ScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Schedule {
        val builtJavaResource = com.pulumi.aws.autoscaling.Schedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Schedule(builtJavaResource)
    }
}

/**
 * Provides an AutoScaling Schedule resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foobar = new aws.autoscaling.Group("foobar", {
 *     availabilityZones: ["us-west-2a"],
 *     name: "test-foobar5",
 *     maxSize: 1,
 *     minSize: 1,
 *     healthCheckGracePeriod: 300,
 *     healthCheckType: "ELB",
 *     forceDelete: true,
 *     terminationPolicies: ["OldestInstance"],
 * });
 * const foobarSchedule = new aws.autoscaling.Schedule("foobar", {
 *     scheduledActionName: "foobar",
 *     minSize: 0,
 *     maxSize: 1,
 *     desiredCapacity: 0,
 *     startTime: "2016-12-11T18:00:00Z",
 *     endTime: "2016-12-12T06:00:00Z",
 *     autoscalingGroupName: foobar.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foobar = aws.autoscaling.Group("foobar",
 *     availability_zones=["us-west-2a"],
 *     name="test-foobar5",
 *     max_size=1,
 *     min_size=1,
 *     health_check_grace_period=300,
 *     health_check_type="ELB",
 *     force_delete=True,
 *     termination_policies=["OldestInstance"])
 * foobar_schedule = aws.autoscaling.Schedule("foobar",
 *     scheduled_action_name="foobar",
 *     min_size=0,
 *     max_size=1,
 *     desired_capacity=0,
 *     start_time="2016-12-11T18:00:00Z",
 *     end_time="2016-12-12T06:00:00Z",
 *     autoscaling_group_name=foobar.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foobar = new Aws.AutoScaling.Group("foobar", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *         },
 *         Name = "test-foobar5",
 *         MaxSize = 1,
 *         MinSize = 1,
 *         HealthCheckGracePeriod = 300,
 *         HealthCheckType = "ELB",
 *         ForceDelete = true,
 *         TerminationPolicies = new[]
 *         {
 *             "OldestInstance",
 *         },
 *     });
 *     var foobarSchedule = new Aws.AutoScaling.Schedule("foobar", new()
 *     {
 *         ScheduledActionName = "foobar",
 *         MinSize = 0,
 *         MaxSize = 1,
 *         DesiredCapacity = 0,
 *         StartTime = "2016-12-11T18:00:00Z",
 *         EndTime = "2016-12-12T06:00:00Z",
 *         AutoscalingGroupName = foobar.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foobar, err := autoscaling.NewGroup(ctx, "foobar", &autoscaling.GroupArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 			},
 * 			Name:                   pulumi.String("test-foobar5"),
 * 			MaxSize:                pulumi.Int(1),
 * 			MinSize:                pulumi.Int(1),
 * 			HealthCheckGracePeriod: pulumi.Int(300),
 * 			HealthCheckType:        pulumi.String("ELB"),
 * 			ForceDelete:            pulumi.Bool(true),
 * 			TerminationPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = autoscaling.NewSchedule(ctx, "foobar", &autoscaling.ScheduleArgs{
 * 			ScheduledActionName:  pulumi.String("foobar"),
 * 			MinSize:              pulumi.Int(0),
 * 			MaxSize:              pulumi.Int(1),
 * 			DesiredCapacity:      pulumi.Int(0),
 * 			StartTime:            pulumi.String("2016-12-11T18:00:00Z"),
 * 			EndTime:              pulumi.String("2016-12-12T06:00:00Z"),
 * 			AutoscalingGroupName: foobar.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.Schedule;
 * import com.pulumi.aws.autoscaling.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new Group("foobar", GroupArgs.builder()
 *             .availabilityZones("us-west-2a")
 *             .name("test-foobar5")
 *             .maxSize(1)
 *             .minSize(1)
 *             .healthCheckGracePeriod(300)
 *             .healthCheckType("ELB")
 *             .forceDelete(true)
 *             .terminationPolicies("OldestInstance")
 *             .build());
 *         var foobarSchedule = new Schedule("foobarSchedule", ScheduleArgs.builder()
 *             .scheduledActionName("foobar")
 *             .minSize(0)
 *             .maxSize(1)
 *             .desiredCapacity(0)
 *             .startTime("2016-12-11T18:00:00Z")
 *             .endTime("2016-12-12T06:00:00Z")
 *             .autoscalingGroupName(foobar.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foobar:
 *     type: aws:autoscaling:Group
 *     properties:
 *       availabilityZones:
 *         - us-west-2a
 *       name: test-foobar5
 *       maxSize: 1
 *       minSize: 1
 *       healthCheckGracePeriod: 300
 *       healthCheckType: ELB
 *       forceDelete: true
 *       terminationPolicies:
 *         - OldestInstance
 *   foobarSchedule:
 *     type: aws:autoscaling:Schedule
 *     name: foobar
 *     properties:
 *       scheduledActionName: foobar
 *       minSize: 0
 *       maxSize: 1
 *       desiredCapacity: 0
 *       startTime: 2016-12-11T18:00:00Z
 *       endTime: 2016-12-12T06:00:00Z
 *       autoscalingGroupName: ${foobar.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AutoScaling ScheduledAction using the `auto-scaling-group-name` and `scheduled-action-name`. For example:
 * ```sh
 * $ pulumi import aws:autoscaling/schedule:Schedule resource-name auto-scaling-group-name/scheduled-action-name
 * ```
 */
public class Schedule internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.Schedule,
) : KotlinCustomResource(javaResource, ScheduleMapper) {
    /**
     * ARN assigned by AWS to the autoscaling schedule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the Auto Scaling group.
     */
    public val autoscalingGroupName: Output<String>
        get() = javaResource.autoscalingGroupName().applyValue({ args0 -> args0 })

    /**
     * The initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. Set to `-1` if you don't want to change the desired capacity at the scheduled time. Defaults to `0`.
     */
    public val desiredCapacity: Output<Int>
        get() = javaResource.desiredCapacity().applyValue({ args0 -> args0 })

    /**
     * The date and time for the recurring schedule to end, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    public val endTime: Output<String>
        get() = javaResource.endTime().applyValue({ args0 -> args0 })

    /**
     * The maximum size of the Auto Scaling group. Set to `-1` if you don't want to change the maximum size at the scheduled time. Defaults to `0`.
     */
    public val maxSize: Output<Int>
        get() = javaResource.maxSize().applyValue({ args0 -> args0 })

    /**
     * The minimum size of the Auto Scaling group. Set to `-1` if you don't want to change the minimum size at the scheduled time. Defaults to `0`.
     */
    public val minSize: Output<Int>
        get() = javaResource.minSize().applyValue({ args0 -> args0 })

    /**
     * The recurring schedule for this action specified using the Unix cron syntax format.
     */
    public val recurrence: Output<String>
        get() = javaResource.recurrence().applyValue({ args0 -> args0 })

    /**
     * The name of this scaling action.
     * The following arguments are optional:
     */
    public val scheduledActionName: Output<String>
        get() = javaResource.scheduledActionName().applyValue({ args0 -> args0 })

    /**
     * The date and time for the recurring schedule to start, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Specifies the time zone for a cron expression. Valid values are the canonical names of the IANA time zones (such as `Etc/GMT+9` or `Pacific/Tahiti`).
     * > **NOTE:** When `start_time` and `end_time` are specified with `recurrence` , they form the boundaries of when the recurring action will start and stop.
     */
    public val timeZone: Output<String>
        get() = javaResource.timeZone().applyValue({ args0 -> args0 })
}

public object ScheduleMapper : ResourceMapper<Schedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.Schedule::class == javaResource::class

    override fun map(javaResource: Resource): Schedule = Schedule(
        javaResource as
            com.pulumi.aws.autoscaling.Schedule,
    )
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Schedule].
 */
public suspend fun schedule(name: String, block: suspend ScheduleResourceBuilder.() -> Unit): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Schedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun schedule(name: String): Schedule {
    val builder = ScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
