@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.ScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AutoScaling Schedule resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foobar = new aws.autoscaling.Group("foobar", {
 *     availabilityZones: ["us-west-2a"],
 *     name: "test-foobar5",
 *     maxSize: 1,
 *     minSize: 1,
 *     healthCheckGracePeriod: 300,
 *     healthCheckType: "ELB",
 *     forceDelete: true,
 *     terminationPolicies: ["OldestInstance"],
 * });
 * const foobarSchedule = new aws.autoscaling.Schedule("foobar", {
 *     scheduledActionName: "foobar",
 *     minSize: 0,
 *     maxSize: 1,
 *     desiredCapacity: 0,
 *     startTime: "2016-12-11T18:00:00Z",
 *     endTime: "2016-12-12T06:00:00Z",
 *     autoscalingGroupName: foobar.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foobar = aws.autoscaling.Group("foobar",
 *     availability_zones=["us-west-2a"],
 *     name="test-foobar5",
 *     max_size=1,
 *     min_size=1,
 *     health_check_grace_period=300,
 *     health_check_type="ELB",
 *     force_delete=True,
 *     termination_policies=["OldestInstance"])
 * foobar_schedule = aws.autoscaling.Schedule("foobar",
 *     scheduled_action_name="foobar",
 *     min_size=0,
 *     max_size=1,
 *     desired_capacity=0,
 *     start_time="2016-12-11T18:00:00Z",
 *     end_time="2016-12-12T06:00:00Z",
 *     autoscaling_group_name=foobar.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foobar = new Aws.AutoScaling.Group("foobar", new()
 *     {
 *         AvailabilityZones = new[]
 *         {
 *             "us-west-2a",
 *         },
 *         Name = "test-foobar5",
 *         MaxSize = 1,
 *         MinSize = 1,
 *         HealthCheckGracePeriod = 300,
 *         HealthCheckType = "ELB",
 *         ForceDelete = true,
 *         TerminationPolicies = new[]
 *         {
 *             "OldestInstance",
 *         },
 *     });
 *     var foobarSchedule = new Aws.AutoScaling.Schedule("foobar", new()
 *     {
 *         ScheduledActionName = "foobar",
 *         MinSize = 0,
 *         MaxSize = 1,
 *         DesiredCapacity = 0,
 *         StartTime = "2016-12-11T18:00:00Z",
 *         EndTime = "2016-12-12T06:00:00Z",
 *         AutoscalingGroupName = foobar.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/autoscaling"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		foobar, err := autoscaling.NewGroup(ctx, "foobar", &autoscaling.GroupArgs{
 * 			AvailabilityZones: pulumi.StringArray{
 * 				pulumi.String("us-west-2a"),
 * 			},
 * 			Name:                   pulumi.String("test-foobar5"),
 * 			MaxSize:                pulumi.Int(1),
 * 			MinSize:                pulumi.Int(1),
 * 			HealthCheckGracePeriod: pulumi.Int(300),
 * 			HealthCheckType:        pulumi.String("ELB"),
 * 			ForceDelete:            pulumi.Bool(true),
 * 			TerminationPolicies: pulumi.StringArray{
 * 				pulumi.String("OldestInstance"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = autoscaling.NewSchedule(ctx, "foobar", &autoscaling.ScheduleArgs{
 * 			ScheduledActionName:  pulumi.String("foobar"),
 * 			MinSize:              pulumi.Int(0),
 * 			MaxSize:              pulumi.Int(1),
 * 			DesiredCapacity:      pulumi.Int(0),
 * 			StartTime:            pulumi.String("2016-12-11T18:00:00Z"),
 * 			EndTime:              pulumi.String("2016-12-12T06:00:00Z"),
 * 			AutoscalingGroupName: foobar.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.autoscaling.Group;
 * import com.pulumi.aws.autoscaling.GroupArgs;
 * import com.pulumi.aws.autoscaling.Schedule;
 * import com.pulumi.aws.autoscaling.ScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foobar = new Group("foobar", GroupArgs.builder()
 *             .availabilityZones("us-west-2a")
 *             .name("test-foobar5")
 *             .maxSize(1)
 *             .minSize(1)
 *             .healthCheckGracePeriod(300)
 *             .healthCheckType("ELB")
 *             .forceDelete(true)
 *             .terminationPolicies("OldestInstance")
 *             .build());
 *         var foobarSchedule = new Schedule("foobarSchedule", ScheduleArgs.builder()
 *             .scheduledActionName("foobar")
 *             .minSize(0)
 *             .maxSize(1)
 *             .desiredCapacity(0)
 *             .startTime("2016-12-11T18:00:00Z")
 *             .endTime("2016-12-12T06:00:00Z")
 *             .autoscalingGroupName(foobar.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foobar:
 *     type: aws:autoscaling:Group
 *     properties:
 *       availabilityZones:
 *         - us-west-2a
 *       name: test-foobar5
 *       maxSize: 1
 *       minSize: 1
 *       healthCheckGracePeriod: 300
 *       healthCheckType: ELB
 *       forceDelete: true
 *       terminationPolicies:
 *         - OldestInstance
 *   foobarSchedule:
 *     type: aws:autoscaling:Schedule
 *     name: foobar
 *     properties:
 *       scheduledActionName: foobar
 *       minSize: 0
 *       maxSize: 1
 *       desiredCapacity: 0
 *       startTime: 2016-12-11T18:00:00Z
 *       endTime: 2016-12-12T06:00:00Z
 *       autoscalingGroupName: ${foobar.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AutoScaling ScheduledAction using the `auto-scaling-group-name` and `scheduled-action-name`. For example:
 * ```sh
 * $ pulumi import aws:autoscaling/schedule:Schedule resource-name auto-scaling-group-name/scheduled-action-name
 * ```
 * @property autoscalingGroupName The name of the Auto Scaling group.
 * @property desiredCapacity The initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. Set to `-1` if you don't want to change the desired capacity at the scheduled time. Defaults to `0`.
 * @property endTime The date and time for the recurring schedule to end, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
 * @property maxSize The maximum size of the Auto Scaling group. Set to `-1` if you don't want to change the maximum size at the scheduled time. Defaults to `0`.
 * @property minSize The minimum size of the Auto Scaling group. Set to `-1` if you don't want to change the minimum size at the scheduled time. Defaults to `0`.
 * @property recurrence The recurring schedule for this action specified using the Unix cron syntax format.
 * @property scheduledActionName The name of this scaling action.
 * The following arguments are optional:
 * @property startTime The date and time for the recurring schedule to start, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
 * @property timeZone Specifies the time zone for a cron expression. Valid values are the canonical names of the IANA time zones (such as `Etc/GMT+9` or `Pacific/Tahiti`).
 * > **NOTE:** When `start_time` and `end_time` are specified with `recurrence` , they form the boundaries of when the recurring action will start and stop.
 */
public data class ScheduleArgs(
    public val autoscalingGroupName: Output<String>? = null,
    public val desiredCapacity: Output<Int>? = null,
    public val endTime: Output<String>? = null,
    public val maxSize: Output<Int>? = null,
    public val minSize: Output<Int>? = null,
    public val recurrence: Output<String>? = null,
    public val scheduledActionName: Output<String>? = null,
    public val startTime: Output<String>? = null,
    public val timeZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.ScheduleArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.ScheduleArgs =
        com.pulumi.aws.autoscaling.ScheduleArgs.builder()
            .autoscalingGroupName(autoscalingGroupName?.applyValue({ args0 -> args0 }))
            .desiredCapacity(desiredCapacity?.applyValue({ args0 -> args0 }))
            .endTime(endTime?.applyValue({ args0 -> args0 }))
            .maxSize(maxSize?.applyValue({ args0 -> args0 }))
            .minSize(minSize?.applyValue({ args0 -> args0 }))
            .recurrence(recurrence?.applyValue({ args0 -> args0 }))
            .scheduledActionName(scheduledActionName?.applyValue({ args0 -> args0 }))
            .startTime(startTime?.applyValue({ args0 -> args0 }))
            .timeZone(timeZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleArgs].
 */
@PulumiTagMarker
public class ScheduleArgsBuilder internal constructor() {
    private var autoscalingGroupName: Output<String>? = null

    private var desiredCapacity: Output<Int>? = null

    private var endTime: Output<String>? = null

    private var maxSize: Output<Int>? = null

    private var minSize: Output<Int>? = null

    private var recurrence: Output<String>? = null

    private var scheduledActionName: Output<String>? = null

    private var startTime: Output<String>? = null

    private var timeZone: Output<String>? = null

    /**
     * @param value The name of the Auto Scaling group.
     */
    @JvmName("hkmdklbikrrpvygt")
    public suspend fun autoscalingGroupName(`value`: Output<String>) {
        this.autoscalingGroupName = value
    }

    /**
     * @param value The initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. Set to `-1` if you don't want to change the desired capacity at the scheduled time. Defaults to `0`.
     */
    @JvmName("nlasoykxydhftiwd")
    public suspend fun desiredCapacity(`value`: Output<Int>) {
        this.desiredCapacity = value
    }

    /**
     * @param value The date and time for the recurring schedule to end, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    @JvmName("xfaaqgjnncgwxnid")
    public suspend fun endTime(`value`: Output<String>) {
        this.endTime = value
    }

    /**
     * @param value The maximum size of the Auto Scaling group. Set to `-1` if you don't want to change the maximum size at the scheduled time. Defaults to `0`.
     */
    @JvmName("eugxonnjbeyhjgbf")
    public suspend fun maxSize(`value`: Output<Int>) {
        this.maxSize = value
    }

    /**
     * @param value The minimum size of the Auto Scaling group. Set to `-1` if you don't want to change the minimum size at the scheduled time. Defaults to `0`.
     */
    @JvmName("nodqmmvypjhxgkkw")
    public suspend fun minSize(`value`: Output<Int>) {
        this.minSize = value
    }

    /**
     * @param value The recurring schedule for this action specified using the Unix cron syntax format.
     */
    @JvmName("jmkjjvkmknvacgjq")
    public suspend fun recurrence(`value`: Output<String>) {
        this.recurrence = value
    }

    /**
     * @param value The name of this scaling action.
     * The following arguments are optional:
     */
    @JvmName("jmftqyiofeytvbbq")
    public suspend fun scheduledActionName(`value`: Output<String>) {
        this.scheduledActionName = value
    }

    /**
     * @param value The date and time for the recurring schedule to start, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    @JvmName("lhwouiobceejtcqp")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Specifies the time zone for a cron expression. Valid values are the canonical names of the IANA time zones (such as `Etc/GMT+9` or `Pacific/Tahiti`).
     * > **NOTE:** When `start_time` and `end_time` are specified with `recurrence` , they form the boundaries of when the recurring action will start and stop.
     */
    @JvmName("ugqaijrgejuuwlyk")
    public suspend fun timeZone(`value`: Output<String>) {
        this.timeZone = value
    }

    /**
     * @param value The name of the Auto Scaling group.
     */
    @JvmName("kpumpeqnjvnitffw")
    public suspend fun autoscalingGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoscalingGroupName = mapped
    }

    /**
     * @param value The initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. Set to `-1` if you don't want to change the desired capacity at the scheduled time. Defaults to `0`.
     */
    @JvmName("sfgrdqdjormiwjdx")
    public suspend fun desiredCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredCapacity = mapped
    }

    /**
     * @param value The date and time for the recurring schedule to end, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    @JvmName("aveanbvqlxjnysfd")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTime = mapped
    }

    /**
     * @param value The maximum size of the Auto Scaling group. Set to `-1` if you don't want to change the maximum size at the scheduled time. Defaults to `0`.
     */
    @JvmName("kladejvlkdwuwofn")
    public suspend fun maxSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSize = mapped
    }

    /**
     * @param value The minimum size of the Auto Scaling group. Set to `-1` if you don't want to change the minimum size at the scheduled time. Defaults to `0`.
     */
    @JvmName("ufkhhrsdwvjhyrex")
    public suspend fun minSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minSize = mapped
    }

    /**
     * @param value The recurring schedule for this action specified using the Unix cron syntax format.
     */
    @JvmName("xonkeffxsgxweogi")
    public suspend fun recurrence(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recurrence = mapped
    }

    /**
     * @param value The name of this scaling action.
     * The following arguments are optional:
     */
    @JvmName("tcucmpimijjqmbtp")
    public suspend fun scheduledActionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduledActionName = mapped
    }

    /**
     * @param value The date and time for the recurring schedule to start, in UTC with the format `"YYYY-MM-DDThh:mm:ssZ"` (e.g. `"2021-06-01T00:00:00Z"`).
     */
    @JvmName("wklpouumdgdocumh")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Specifies the time zone for a cron expression. Valid values are the canonical names of the IANA time zones (such as `Etc/GMT+9` or `Pacific/Tahiti`).
     * > **NOTE:** When `start_time` and `end_time` are specified with `recurrence` , they form the boundaries of when the recurring action will start and stop.
     */
    @JvmName("whsdbrsfcgrdbecn")
    public suspend fun timeZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZone = mapped
    }

    internal fun build(): ScheduleArgs = ScheduleArgs(
        autoscalingGroupName = autoscalingGroupName,
        desiredCapacity = desiredCapacity,
        endTime = endTime,
        maxSize = maxSize,
        minSize = minSize,
        recurrence = recurrence,
        scheduledActionName = scheduledActionName,
        startTime = startTime,
        timeZone = timeZone,
    )
}
