@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin

import com.pulumi.aws.autoscaling.kotlin.outputs.TagTag
import com.pulumi.aws.autoscaling.kotlin.outputs.TagTag.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Tag].
 */
@PulumiTagMarker
public class TagResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TagArgs = TagArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TagArgsBuilder.() -> Unit) {
        val builder = TagArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Tag {
        val builtJavaResource = com.pulumi.aws.autoscaling.Tag(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Tag(builtJavaResource)
    }
}

/**
 * Manages an individual Autoscaling Group (ASG) tag. This resource should only be used in cases where ASGs are created outside the provider (e.g., ASGs implicitly created by EKS Node Groups).
 * > **NOTE:** This tagging resource should not be combined with the resource for managing the parent resource. For example, using `aws.autoscaling.Group` and `aws.autoscaling.Tag` to manage tags of the same ASG will cause a perpetual difference where the `aws.autoscaling.Group` resource will try to remove the tag being added by the `aws.autoscaling.Tag` resource.
 * > **NOTE:** This tagging resource does not use the provider `ignore_tags` configuration.
 * ## Import
 * Using `pulumi import`, import `aws_autoscaling_group_tag` using the ASG name and key, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:autoscaling/tag:Tag example asg-example,k8s.io/cluster-autoscaler/node-template/label/eks.amazonaws.com/capacityType
 * ```
 */
public class Tag internal constructor(
    override val javaResource: com.pulumi.aws.autoscaling.Tag,
) : KotlinCustomResource(javaResource, TagMapper) {
    /**
     * Name of the Autoscaling Group to apply the tag to.
     */
    public val autoscalingGroupName: Output<String>
        get() = javaResource.autoscalingGroupName().applyValue({ args0 -> args0 })

    /**
     * Tag to create. The `tag` block is documented below.
     */
    public val tag: Output<TagTag>
        get() = javaResource.tag().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })
}

public object TagMapper : ResourceMapper<Tag> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.autoscaling.Tag::class == javaResource::class

    override fun map(javaResource: Resource): Tag = Tag(
        javaResource as
            com.pulumi.aws.autoscaling.Tag,
    )
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Tag].
 */
public suspend fun tag(name: String, block: suspend TagResourceBuilder.() -> Unit): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Tag].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tag(name: String): Tag {
    val builder = TagResourceBuilder()
    builder.name(name)
    return builder.build()
}
