@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * See https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_NotificationConfiguration.html
 */
public enum class NotificationType(
    public val javaValue: com.pulumi.aws.autoscaling.enums.NotificationType,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.enums.NotificationType> {
    InstanceLaunch(com.pulumi.aws.autoscaling.enums.NotificationType.InstanceLaunch),
    InstanceTerminate(com.pulumi.aws.autoscaling.enums.NotificationType.InstanceTerminate),
    InstanceLaunchError(com.pulumi.aws.autoscaling.enums.NotificationType.InstanceLaunchError),
    InstanceTerminateError(com.pulumi.aws.autoscaling.enums.NotificationType.InstanceTerminateError),
    TestNotification(com.pulumi.aws.autoscaling.enums.NotificationType.TestNotification),
    ;

    override fun toJava(): com.pulumi.aws.autoscaling.enums.NotificationType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.autoscaling.enums.NotificationType): NotificationType = NotificationType.values().first { it.javaValue == javaType }
    }
}
