@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GetAmiIdsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAmiIds.
 * @property filters Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
 * @property names List of autoscaling group names
 */
public data class GetAmiIdsPlainArgs(
    public val filters: List<GetAmiIdsFilter>? = null,
    public val names: List<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GetAmiIdsPlainArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GetAmiIdsPlainArgs =
        com.pulumi.aws.autoscaling.inputs.GetAmiIdsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .names(names?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetAmiIdsPlainArgs].
 */
@PulumiTagMarker
public class GetAmiIdsPlainArgsBuilder internal constructor() {
    private var filters: List<GetAmiIdsFilter>? = null

    private var names: List<String>? = null

    /**
     * @param value Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     */
    @JvmName("gprcxvsajfgtsbjs")
    public suspend fun filters(`value`: List<GetAmiIdsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     */
    @JvmName("yfmqunfrvabmrktc")
    public suspend fun filters(argument: List<suspend GetAmiIdsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetAmiIdsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     */
    @JvmName("nmqgpergyqlnxrcc")
    public suspend fun filters(vararg argument: suspend GetAmiIdsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetAmiIdsFilterBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     */
    @JvmName("jjxpofadngqfoxkt")
    public suspend fun filters(argument: suspend GetAmiIdsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetAmiIdsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Filter used to scope the list e.g., by tags. See [related docs](http://docs.aws.amazon.com/AutoScaling/latest/APIReference/API_Filter.html).
     */
    @JvmName("txjcpcsgonmcvbdx")
    public suspend fun filters(vararg values: GetAmiIdsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value List of autoscaling group names
     */
    @JvmName("hyfatopcmpjpuprn")
    public suspend fun names(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.names = mapped
    }

    /**
     * @param values List of autoscaling group names
     */
    @JvmName("ecyhsspxgvsrarrj")
    public suspend fun names(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.names = mapped
    }

    internal fun build(): GetAmiIdsPlainArgs = GetAmiIdsPlainArgs(
        filters = filters,
        names = names,
    )
}
