@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesAlarmSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alarms List of Cloudwatch alarms. If any of these alarms goes into ALARM state, Instance Refresh is failed.
 */
public data class GroupInstanceRefreshPreferencesAlarmSpecificationArgs(
    public val alarms: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesAlarmSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesAlarmSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.GroupInstanceRefreshPreferencesAlarmSpecificationArgs.builder()
            .alarms(alarms?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GroupInstanceRefreshPreferencesAlarmSpecificationArgs].
 */
@PulumiTagMarker
public class GroupInstanceRefreshPreferencesAlarmSpecificationArgsBuilder internal constructor() {
    private var alarms: Output<List<String>>? = null

    /**
     * @param value List of Cloudwatch alarms. If any of these alarms goes into ALARM state, Instance Refresh is failed.
     */
    @JvmName("ommmqkkkhuqdrhcm")
    public suspend fun alarms(`value`: Output<List<String>>) {
        this.alarms = value
    }

    @JvmName("fgbvmeecrqketryy")
    public suspend fun alarms(vararg values: Output<String>) {
        this.alarms = Output.all(values.asList())
    }

    /**
     * @param values List of Cloudwatch alarms. If any of these alarms goes into ALARM state, Instance Refresh is failed.
     */
    @JvmName("qpjnohuqswpjvqqn")
    public suspend fun alarms(values: List<Output<String>>) {
        this.alarms = Output.all(values)
    }

    /**
     * @param value List of Cloudwatch alarms. If any of these alarms goes into ALARM state, Instance Refresh is failed.
     */
    @JvmName("ssbhnkongaciixff")
    public suspend fun alarms(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    /**
     * @param values List of Cloudwatch alarms. If any of these alarms goes into ALARM state, Instance Refresh is failed.
     */
    @JvmName("okrsjqmrqfkfrtbu")
    public suspend fun alarms(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alarms = mapped
    }

    internal fun build(): GroupInstanceRefreshPreferencesAlarmSpecificationArgs =
        GroupInstanceRefreshPreferencesAlarmSpecificationArgs(
            alarms = alarms,
        )
}
