@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property acceleratorCount Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
 * @property acceleratorManufacturers List of accelerator manufacturer names. Default is any manufacturer.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * nvidia
 * * xilinx
 * ```
 * @property acceleratorNames List of accelerator names. Default is any acclerator.
 * ```
 * Valid names:
 * * a100            - NVIDIA A100 GPUs
 * * v100            - NVIDIA V100 GPUs
 * * k80             - NVIDIA K80 GPUs
 * * t4              - NVIDIA T4 GPUs
 * * m60             - NVIDIA M60 GPUs
 * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
 * * vu9p            - Xilinx VU9P FPGAs
 * ```
 * @property acceleratorTotalMemoryMib Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
 * @property acceleratorTypes List of accelerator types. Default is any accelerator type.
 * ```
 * Valid types:
 * * fpga
 * * gpu
 * * inference
 * ```
 * @property allowedInstanceTypes List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
 * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
 * @property bareMetal Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property baselineEbsBandwidthMbps Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
 * @property burstablePerformance Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
 * @property cpuManufacturers List of CPU manufacturer names. Default is any manufacturer.
 * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
 * ```
 * Valid names:
 * * amazon-web-services
 * * amd
 * * intel
 * ```
 * @property excludedInstanceTypes List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
 * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
 * @property instanceGenerations List of instance generation names. Default is any generation.
 * ```
 * Valid names:
 * * current  - Recommended for best performance.
 * * previous - For existing applications optimized for older instance types.
 * ```
 * @property localStorage Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
 * @property localStorageTypes List of local storage type names. Default any storage type.
 * ```
 * Value names:
 * * hdd - hard disk drive
 * * ssd - solid state drive
 * ```
 * @property maxSpotPriceAsPercentageOfOptimalOnDemandPrice The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Conflicts with `spot_max_price_percentage_over_lowest_price`
 * @property memoryGibPerVcpu Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
 * @property memoryMib Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
 * @property networkBandwidthGbps Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
 * @property networkInterfaceCount Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
 * @property onDemandMaxPricePercentageOverLowestPrice Price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property requireHibernateSupport Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
 * @property spotMaxPricePercentageOverLowestPrice Price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100. Conflicts with `max_spot_price_as_percentage_of_optimal_on_demand_price`
 * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
 * @property totalLocalStorageGb Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
 * @property vcpuCount Block describing the minimum and maximum number of vCPUs. Default is no maximum.
 */
public data class GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs(
    public val acceleratorCount: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null,
    public val acceleratorManufacturers: Output<List<String>>? = null,
    public val acceleratorNames: Output<List<String>>? = null,
    public val acceleratorTotalMemoryMib: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null,
    public val acceleratorTypes: Output<List<String>>? = null,
    public val allowedInstanceTypes: Output<List<String>>? = null,
    public val bareMetal: Output<String>? = null,
    public val baselineEbsBandwidthMbps: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null,
    public val burstablePerformance: Output<String>? = null,
    public val cpuManufacturers: Output<List<String>>? = null,
    public val excludedInstanceTypes: Output<List<String>>? = null,
    public val instanceGenerations: Output<List<String>>? = null,
    public val localStorage: Output<String>? = null,
    public val localStorageTypes: Output<List<String>>? = null,
    public val maxSpotPriceAsPercentageOfOptimalOnDemandPrice: Output<Int>? = null,
    public val memoryGibPerVcpu: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null,
    public val memoryMib: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs>? =
        null,
    public val networkBandwidthGbps: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null,
    public val networkInterfaceCount: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null,
    public val onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val requireHibernateSupport: Output<Boolean>? = null,
    public val spotMaxPricePercentageOverLowestPrice: Output<Int>? = null,
    public val totalLocalStorageGb: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null,
    public val vcpuCount: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs =
        com.pulumi.aws.autoscaling.inputs.GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs.builder()
            .acceleratorCount(acceleratorCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .acceleratorManufacturers(
                acceleratorManufacturers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .acceleratorNames(acceleratorNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .acceleratorTotalMemoryMib(
                acceleratorTotalMemoryMib?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .acceleratorTypes(acceleratorTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedInstanceTypes(allowedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .bareMetal(bareMetal?.applyValue({ args0 -> args0 }))
            .baselineEbsBandwidthMbps(
                baselineEbsBandwidthMbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .burstablePerformance(burstablePerformance?.applyValue({ args0 -> args0 }))
            .cpuManufacturers(cpuManufacturers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludedInstanceTypes(excludedInstanceTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceGenerations(instanceGenerations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .localStorage(localStorage?.applyValue({ args0 -> args0 }))
            .localStorageTypes(localStorageTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxSpotPriceAsPercentageOfOptimalOnDemandPrice(
                maxSpotPriceAsPercentageOfOptimalOnDemandPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .memoryGibPerVcpu(memoryGibPerVcpu?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .memoryMib(memoryMib?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .networkBandwidthGbps(
                networkBandwidthGbps?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkInterfaceCount(
                networkInterfaceCount?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .onDemandMaxPricePercentageOverLowestPrice(
                onDemandMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .requireHibernateSupport(requireHibernateSupport?.applyValue({ args0 -> args0 }))
            .spotMaxPricePercentageOverLowestPrice(
                spotMaxPricePercentageOverLowestPrice?.applyValue({ args0 ->
                    args0
                }),
            )
            .totalLocalStorageGb(
                totalLocalStorageGb?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vcpuCount(vcpuCount?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs].
 */
@PulumiTagMarker
public class GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgsBuilder internal constructor() {
    private var acceleratorCount:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgs>? =
        null

    private var acceleratorManufacturers: Output<List<String>>? = null

    private var acceleratorNames: Output<List<String>>? = null

    private var acceleratorTotalMemoryMib:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>? =
        null

    private var acceleratorTypes: Output<List<String>>? = null

    private var allowedInstanceTypes: Output<List<String>>? = null

    private var bareMetal: Output<String>? = null

    private var baselineEbsBandwidthMbps:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>? =
        null

    private var burstablePerformance: Output<String>? = null

    private var cpuManufacturers: Output<List<String>>? = null

    private var excludedInstanceTypes: Output<List<String>>? = null

    private var instanceGenerations: Output<List<String>>? = null

    private var localStorage: Output<String>? = null

    private var localStorageTypes: Output<List<String>>? = null

    private var maxSpotPriceAsPercentageOfOptimalOnDemandPrice: Output<Int>? = null

    private var memoryGibPerVcpu:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgs>? =
        null

    private var memoryMib:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs>? =
        null

    private var networkBandwidthGbps:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>? =
        null

    private var networkInterfaceCount:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgs>? =
        null

    private var onDemandMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var requireHibernateSupport: Output<Boolean>? = null

    private var spotMaxPricePercentageOverLowestPrice: Output<Int>? = null

    private var totalLocalStorageGb:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgs>? =
        null

    private var vcpuCount:
        Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs>? =
        null

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("mcjuwpvgdhaqxipm")
    public suspend fun acceleratorCount(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgs>) {
        this.acceleratorCount = value
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("lgqsqqsptjgrpokm")
    public suspend fun acceleratorManufacturers(`value`: Output<List<String>>) {
        this.acceleratorManufacturers = value
    }

    @JvmName("qonepoefgwppnjvw")
    public suspend fun acceleratorManufacturers(vararg values: Output<String>) {
        this.acceleratorManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("coqhdkclggunncln")
    public suspend fun acceleratorManufacturers(values: List<Output<String>>) {
        this.acceleratorManufacturers = Output.all(values)
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("devkjtcslgqlefyh")
    public suspend fun acceleratorNames(`value`: Output<List<String>>) {
        this.acceleratorNames = value
    }

    @JvmName("eoryccmwuvnqolpv")
    public suspend fun acceleratorNames(vararg values: Output<String>) {
        this.acceleratorNames = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("bmvivfhecahrsddm")
    public suspend fun acceleratorNames(values: List<Output<String>>) {
        this.acceleratorNames = Output.all(values)
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("talhqwedhnnampad")
    public suspend fun acceleratorTotalMemoryMib(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs>) {
        this.acceleratorTotalMemoryMib = value
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("pgibriobtpmjcobq")
    public suspend fun acceleratorTypes(`value`: Output<List<String>>) {
        this.acceleratorTypes = value
    }

    @JvmName("akyufgdxcoovwvos")
    public suspend fun acceleratorTypes(vararg values: Output<String>) {
        this.acceleratorTypes = Output.all(values.asList())
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("ymfmiubfrooyvppk")
    public suspend fun acceleratorTypes(values: List<Output<String>>) {
        this.acceleratorTypes = Output.all(values)
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("oyhntktcopgltien")
    public suspend fun allowedInstanceTypes(`value`: Output<List<String>>) {
        this.allowedInstanceTypes = value
    }

    @JvmName("ktvkagmdrlmflsvq")
    public suspend fun allowedInstanceTypes(vararg values: Output<String>) {
        this.allowedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("rkqcpsqvursqkflh")
    public suspend fun allowedInstanceTypes(values: List<Output<String>>) {
        this.allowedInstanceTypes = Output.all(values)
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("opqanqfrjeprethn")
    public suspend fun bareMetal(`value`: Output<String>) {
        this.bareMetal = value
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("pqlludexiwscubfm")
    public suspend fun baselineEbsBandwidthMbps(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs>) {
        this.baselineEbsBandwidthMbps = value
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("dlkvwiajrygktjxm")
    public suspend fun burstablePerformance(`value`: Output<String>) {
        this.burstablePerformance = value
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("fpcjnxlppalhxjnp")
    public suspend fun cpuManufacturers(`value`: Output<List<String>>) {
        this.cpuManufacturers = value
    }

    @JvmName("ufeleonywlwdfugc")
    public suspend fun cpuManufacturers(vararg values: Output<String>) {
        this.cpuManufacturers = Output.all(values.asList())
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("qgganbxfulxafkck")
    public suspend fun cpuManufacturers(values: List<Output<String>>) {
        this.cpuManufacturers = Output.all(values)
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("uahfdnioqvttxftn")
    public suspend fun excludedInstanceTypes(`value`: Output<List<String>>) {
        this.excludedInstanceTypes = value
    }

    @JvmName("wxvmfukhqdyjanai")
    public suspend fun excludedInstanceTypes(vararg values: Output<String>) {
        this.excludedInstanceTypes = Output.all(values.asList())
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("hbbencbdhjuqdmjb")
    public suspend fun excludedInstanceTypes(values: List<Output<String>>) {
        this.excludedInstanceTypes = Output.all(values)
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("qultpwlbnxubbriw")
    public suspend fun instanceGenerations(`value`: Output<List<String>>) {
        this.instanceGenerations = value
    }

    @JvmName("lwyvmawfvsywowke")
    public suspend fun instanceGenerations(vararg values: Output<String>) {
        this.instanceGenerations = Output.all(values.asList())
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("uayvfwqfpdoonscr")
    public suspend fun instanceGenerations(values: List<Output<String>>) {
        this.instanceGenerations = Output.all(values)
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("xayftaspdttdhogj")
    public suspend fun localStorage(`value`: Output<String>) {
        this.localStorage = value
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("ehnrmcjtdwywtxms")
    public suspend fun localStorageTypes(`value`: Output<List<String>>) {
        this.localStorageTypes = value
    }

    @JvmName("gifdcgimwenlasad")
    public suspend fun localStorageTypes(vararg values: Output<String>) {
        this.localStorageTypes = Output.all(values.asList())
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("vlbafvtlmdxdvqha")
    public suspend fun localStorageTypes(values: List<Output<String>>) {
        this.localStorageTypes = Output.all(values)
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Conflicts with `spot_max_price_percentage_over_lowest_price`
     */
    @JvmName("rhcaicslxffmfeia")
    public suspend fun maxSpotPriceAsPercentageOfOptimalOnDemandPrice(`value`: Output<Int>) {
        this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("vhgyvdtlduuduqbr")
    public suspend fun memoryGibPerVcpu(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgs>) {
        this.memoryGibPerVcpu = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("ojyrbkhrxxeyoxlk")
    public suspend fun memoryMib(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs>) {
        this.memoryMib = value
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("mrqibqxjmkybxiki")
    public suspend fun networkBandwidthGbps(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgs>) {
        this.networkBandwidthGbps = value
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("bfcaubpboyjmcego")
    public suspend fun networkInterfaceCount(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgs>) {
        this.networkInterfaceCount = value
    }

    /**
     * @param value Price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("rudnvxjxgpbwjolq")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.onDemandMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("siccjdntslrbolqu")
    public suspend fun requireHibernateSupport(`value`: Output<Boolean>) {
        this.requireHibernateSupport = value
    }

    /**
     * @param value Price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100. Conflicts with `max_spot_price_as_percentage_of_optimal_on_demand_price`
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("vhbmofvjbjbdftbx")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Output<Int>) {
        this.spotMaxPricePercentageOverLowestPrice = value
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("nvmlsilddjsrtvwt")
    public suspend fun totalLocalStorageGb(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgs>) {
        this.totalLocalStorageGb = value
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("xwexplkkrqqdtjad")
    public suspend fun vcpuCount(`value`: Output<GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs>) {
        this.vcpuCount = value
    }

    /**
     * @param value Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("jvphjvvhaptxmjjj")
    public suspend fun acceleratorCount(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of accelerators (GPUs, FPGAs, or AWS Inferentia chips). Default is no minimum or maximum.
     */
    @JvmName("qbfgdqqkelctpsgj")
    public suspend fun acceleratorCount(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorCount = mapped
    }

    /**
     * @param value List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("dgyuyeeqfrrgaaym")
    public suspend fun acceleratorManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param values List of accelerator manufacturer names. Default is any manufacturer.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * nvidia
     * * xilinx
     * ```
     */
    @JvmName("nbewgmfcucnvqeie")
    public suspend fun acceleratorManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorManufacturers = mapped
    }

    /**
     * @param value List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("vwbiflgujcmkjcbf")
    public suspend fun acceleratorNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param values List of accelerator names. Default is any acclerator.
     * ```
     * Valid names:
     * * a100            - NVIDIA A100 GPUs
     * * v100            - NVIDIA V100 GPUs
     * * k80             - NVIDIA K80 GPUs
     * * t4              - NVIDIA T4 GPUs
     * * m60             - NVIDIA M60 GPUs
     * * radeon-pro-v520 - AMD Radeon Pro V520 GPUs
     * * vu9p            - Xilinx VU9P FPGAs
     * ```
     */
    @JvmName("xatqnadqrhoivter")
    public suspend fun acceleratorNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorNames = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("sggckirdjxuuiqml")
    public suspend fun acceleratorTotalMemoryMib(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total memory of the accelerators. Default is no minimum or maximum.
     */
    @JvmName("xgcdteeqdorxrofh")
    public suspend fun acceleratorTotalMemoryMib(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsAcceleratorTotalMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.acceleratorTotalMemoryMib = mapped
    }

    /**
     * @param value List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("jogamoinriekfcjf")
    public suspend fun acceleratorTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param values List of accelerator types. Default is any accelerator type.
     * ```
     * Valid types:
     * * fpga
     * * gpu
     * * inference
     * ```
     */
    @JvmName("ivvciajwhvwdsrxc")
    public suspend fun acceleratorTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.acceleratorTypes = mapped
    }

    /**
     * @param value List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("abgjslcwkvclvcsq")
    public suspend fun allowedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to apply your specified attributes against. All other instance types are ignored, even if they match your specified attributes. You can use strings with one or more wild cards, represented by an asterisk (\*), to allow an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are allowing the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are allowing all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is all instance types.
     * > **NOTE:** If you specify `allowed_instance_types`, you can't specify `excluded_instance_types`.
     */
    @JvmName("yxtbxueevcbeqnwn")
    public suspend fun allowedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedInstanceTypes = mapped
    }

    /**
     * @param value Indicate whether bare metal instace types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("auisxdjpffdalula")
    public suspend fun bareMetal(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetal = mapped
    }

    /**
     * @param value Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("afwloxfwadyuwqih")
    public suspend fun baselineEbsBandwidthMbps(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum baseline EBS bandwidth, in Mbps. Default is no minimum or maximum.
     */
    @JvmName("wbujvbtbtskmvnaj")
    public suspend fun baselineEbsBandwidthMbps(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsBaselineEbsBandwidthMbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.baselineEbsBandwidthMbps = mapped
    }

    /**
     * @param value Indicate whether burstable performance instance types should be `included`, `excluded`, or `required`. Default is `excluded`.
     */
    @JvmName("arwchlgawsgqxbnu")
    public suspend fun burstablePerformance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burstablePerformance = mapped
    }

    /**
     * @param value List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("pxletgvwccbnqjdx")
    public suspend fun cpuManufacturers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param values List of CPU manufacturer names. Default is any manufacturer.
     * > **NOTE:** Don't confuse the CPU hardware manufacturer with the CPU hardware architecture. Instances will be launched with a compatible CPU architecture based on the Amazon Machine Image (AMI) that you specify in your launch template.
     * ```
     * Valid names:
     * * amazon-web-services
     * * amd
     * * intel
     * ```
     */
    @JvmName("oeesfpcvvbiusdhi")
    public suspend fun cpuManufacturers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cpuManufacturers = mapped
    }

    /**
     * @param value List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("pfljjwpqwsqxbhji")
    public suspend fun excludedInstanceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param values List of instance types to exclude. You can use strings with one or more wild cards, represented by an asterisk (\*), to exclude an instance type, size, or generation. The following are examples: `m5.8xlarge`, `c5*.*`, `m5a.*`, `r*`, `*3*`. For example, if you specify `c5*`, you are excluding the entire C5 instance family, which includes all C5a and C5n instance types. If you specify `m5a.*`, you are excluding all the M5a instance types, but not the M5n instance types. Maximum of 400 entries in the list; each entry is limited to 30 characters. Default is no excluded instance types.
     * > **NOTE:** If you specify `excluded_instance_types`, you can't specify `allowed_instance_types`.
     */
    @JvmName("bsomwocmjxjapsmc")
    public suspend fun excludedInstanceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludedInstanceTypes = mapped
    }

    /**
     * @param value List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("tloyryyxlcupndya")
    public suspend fun instanceGenerations(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param values List of instance generation names. Default is any generation.
     * ```
     * Valid names:
     * * current  - Recommended for best performance.
     * * previous - For existing applications optimized for older instance types.
     * ```
     */
    @JvmName("cclcvkjctdvekshx")
    public suspend fun instanceGenerations(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceGenerations = mapped
    }

    /**
     * @param value Indicate whether instance types with local storage volumes are `included`, `excluded`, or `required`. Default is `included`.
     */
    @JvmName("srxvcfbcvxsvvffj")
    public suspend fun localStorage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorage = mapped
    }

    /**
     * @param value List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("gjicknvtngcsxlsa")
    public suspend fun localStorageTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param values List of local storage type names. Default any storage type.
     * ```
     * Value names:
     * * hdd - hard disk drive
     * * ssd - solid state drive
     * ```
     */
    @JvmName("pwwubwxllsneunla")
    public suspend fun localStorageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.localStorageTypes = mapped
    }

    /**
     * @param value The price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Conflicts with `spot_max_price_percentage_over_lowest_price`
     */
    @JvmName("tmxdpojrsedvfnnw")
    public suspend fun maxSpotPriceAsPercentageOfOptimalOnDemandPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSpotPriceAsPercentageOfOptimalOnDemandPrice = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("sbwqgdfwaayjbiir")
    public suspend fun memoryGibPerVcpu(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (GiB) per vCPU. Default is no minimum or maximum.
     */
    @JvmName("ddvtcebdawebqkoi")
    public suspend fun memoryGibPerVcpu(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryGibPerVcpuArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryGibPerVcpu = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("fxnxurolyvtukwcl")
    public suspend fun memoryMib(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memoryMib = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of memory (MiB). Default is no maximum.
     */
    @JvmName("epkqfdnsdcevismy")
    public suspend fun memoryMib(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsMemoryMibArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.memoryMib = mapped
    }

    /**
     * @param value Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("vpopxeqeywdrkwww")
    public suspend fun networkBandwidthGbps(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum amount of network bandwidth, in gigabits per second (Gbps). Default is no minimum or maximum.
     */
    @JvmName("iclcbryxleuntkde")
    public suspend fun networkBandwidthGbps(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkBandwidthGbpsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkBandwidthGbps = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("khdodexmugfcixqi")
    public suspend fun networkInterfaceCount(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaceCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of network interfaces. Default is no minimum or maximum.
     */
    @JvmName("gjllligpcdqovjsh")
    public suspend fun networkInterfaceCount(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsNetworkInterfaceCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkInterfaceCount = mapped
    }

    /**
     * @param value Price protection threshold for On-Demand Instances. This is the maximum you’ll pay for an On-Demand Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 20.
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("shpiuniqyqyvqriy")
    public suspend fun onDemandMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onDemandMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Indicate whether instance types must support On-Demand Instance Hibernation, either `true` or `false`. Default is `false`.
     */
    @JvmName("sydaqbpsqmmybcst")
    public suspend fun requireHibernateSupport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireHibernateSupport = mapped
    }

    /**
     * @param value Price protection threshold for Spot Instances. This is the maximum you’ll pay for a Spot Instance, expressed as a percentage higher than the cheapest M, C, or R instance type with your specified attributes. When Amazon EC2 Auto Scaling selects instance types with your attributes, we will exclude instance types whose price is higher than your threshold. The parameter accepts an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off price protection, specify a high value, such as 999999. Default is 100. Conflicts with `max_spot_price_as_percentage_of_optimal_on_demand_price`
     * If you set DesiredCapacityType to vcpu or memory-mib, the price protection threshold is applied based on the per vCPU or per memory price instead of the per instance price.
     */
    @JvmName("ejswyikynyifweoi")
    public suspend fun spotMaxPricePercentageOverLowestPrice(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotMaxPricePercentageOverLowestPrice = mapped
    }

    /**
     * @param value Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("kelacfbbgxubvdnq")
    public suspend fun totalLocalStorageGb(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum total local storage (GB). Default is no minimum or maximum.
     */
    @JvmName("ywahfpnkokgwdrts")
    public suspend fun totalLocalStorageGb(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsTotalLocalStorageGbArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.totalLocalStorageGb = mapped
    }

    /**
     * @param value Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("itxolnqlysiarsff")
    public suspend fun vcpuCount(`value`: GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vcpuCount = mapped
    }

    /**
     * @param argument Block describing the minimum and maximum number of vCPUs. Default is no maximum.
     */
    @JvmName("rxwjgkbytaorlebt")
    public suspend fun vcpuCount(argument: suspend GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgsBuilder.() -> Unit) {
        val toBeMapped =
            GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsVcpuCountArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.vcpuCount = mapped
    }

    internal fun build(): GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs =
        GroupMixedInstancesPolicyLaunchTemplateOverrideInstanceRequirementsArgs(
            acceleratorCount = acceleratorCount,
            acceleratorManufacturers = acceleratorManufacturers,
            acceleratorNames = acceleratorNames,
            acceleratorTotalMemoryMib = acceleratorTotalMemoryMib,
            acceleratorTypes = acceleratorTypes,
            allowedInstanceTypes = allowedInstanceTypes,
            bareMetal = bareMetal,
            baselineEbsBandwidthMbps = baselineEbsBandwidthMbps,
            burstablePerformance = burstablePerformance,
            cpuManufacturers = cpuManufacturers,
            excludedInstanceTypes = excludedInstanceTypes,
            instanceGenerations = instanceGenerations,
            localStorage = localStorage,
            localStorageTypes = localStorageTypes,
            maxSpotPriceAsPercentageOfOptimalOnDemandPrice = maxSpotPriceAsPercentageOfOptimalOnDemandPrice,
            memoryGibPerVcpu = memoryGibPerVcpu,
            memoryMib = memoryMib,
            networkBandwidthGbps = networkBandwidthGbps,
            networkInterfaceCount = networkInterfaceCount,
            onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice,
            requireHibernateSupport = requireHibernateSupport,
            spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice,
            totalLocalStorageGb = totalLocalStorageGb,
            vcpuCount = vcpuCount,
        )
}
