@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Key
 * @property propagateAtLaunch Enables propagation of the tag to
 * Amazon EC2 instances launched via this ASG
 * To declare multiple tags, additional `tag` blocks can be specified.
 * > **NOTE:** Other AWS APIs may automatically add special tags to their associated Auto Scaling Group for management purposes, such as ECS Capacity Providers adding the `AmazonECSManaged` tag. These generally should be included in the configuration so the provider does not attempt to remove them and so if the `min_size` was greater than zero on creation, that these tag(s) are applied to any initial EC2 Instances in the Auto Scaling Group. If these tag(s) were missing in the Auto Scaling Group configuration on creation, affected EC2 Instances missing the tags may require manual intervention of adding the tags to ensure they work properly with the other AWS service.
 * @property value Value
 */
public data class GroupTagArgs(
    public val key: Output<String>,
    public val propagateAtLaunch: Output<Boolean>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupTagArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupTagArgs =
        com.pulumi.aws.autoscaling.inputs.GroupTagArgs.builder()
            .key(key.applyValue({ args0 -> args0 }))
            .propagateAtLaunch(propagateAtLaunch.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupTagArgs].
 */
@PulumiTagMarker
public class GroupTagArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    private var propagateAtLaunch: Output<Boolean>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Key
     */
    @JvmName("bitnyqpdatcmgijs")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Enables propagation of the tag to
     * Amazon EC2 instances launched via this ASG
     * To declare multiple tags, additional `tag` blocks can be specified.
     * > **NOTE:** Other AWS APIs may automatically add special tags to their associated Auto Scaling Group for management purposes, such as ECS Capacity Providers adding the `AmazonECSManaged` tag. These generally should be included in the configuration so the provider does not attempt to remove them and so if the `min_size` was greater than zero on creation, that these tag(s) are applied to any initial EC2 Instances in the Auto Scaling Group. If these tag(s) were missing in the Auto Scaling Group configuration on creation, affected EC2 Instances missing the tags may require manual intervention of adding the tags to ensure they work properly with the other AWS service.
     */
    @JvmName("evudmbyweolmkobw")
    public suspend fun propagateAtLaunch(`value`: Output<Boolean>) {
        this.propagateAtLaunch = value
    }

    /**
     * @param value Value
     */
    @JvmName("dpcsbiemkwpljgcn")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Key
     */
    @JvmName("offoxspcyasmvjii")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Enables propagation of the tag to
     * Amazon EC2 instances launched via this ASG
     * To declare multiple tags, additional `tag` blocks can be specified.
     * > **NOTE:** Other AWS APIs may automatically add special tags to their associated Auto Scaling Group for management purposes, such as ECS Capacity Providers adding the `AmazonECSManaged` tag. These generally should be included in the configuration so the provider does not attempt to remove them and so if the `min_size` was greater than zero on creation, that these tag(s) are applied to any initial EC2 Instances in the Auto Scaling Group. If these tag(s) were missing in the Auto Scaling Group configuration on creation, affected EC2 Instances missing the tags may require manual intervention of adding the tags to ensure they work properly with the other AWS service.
     */
    @JvmName("arrgnouunyxmaxqp")
    public suspend fun propagateAtLaunch(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propagateAtLaunch = mapped
    }

    /**
     * @param value Value
     */
    @JvmName("byemvrmblbxbmcvy")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): GroupTagArgs = GroupTagArgs(
        key = key ?: throw PulumiNullFieldException("key"),
        propagateAtLaunch = propagateAtLaunch ?: throw PulumiNullFieldException("propagateAtLaunch"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
