@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property reuseOnScaleIn Whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
 */
public data class GroupWarmPoolInstanceReusePolicyArgs(
    public val reuseOnScaleIn: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs =
        com.pulumi.aws.autoscaling.inputs.GroupWarmPoolInstanceReusePolicyArgs.builder()
            .reuseOnScaleIn(reuseOnScaleIn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupWarmPoolInstanceReusePolicyArgs].
 */
@PulumiTagMarker
public class GroupWarmPoolInstanceReusePolicyArgsBuilder internal constructor() {
    private var reuseOnScaleIn: Output<Boolean>? = null

    /**
     * @param value Whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
     */
    @JvmName("dkbtvihoekhbmdtd")
    public suspend fun reuseOnScaleIn(`value`: Output<Boolean>) {
        this.reuseOnScaleIn = value
    }

    /**
     * @param value Whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
     */
    @JvmName("ncfdvxrnkeduafpe")
    public suspend fun reuseOnScaleIn(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.reuseOnScaleIn = mapped
    }

    internal fun build(): GroupWarmPoolInstanceReusePolicyArgs = GroupWarmPoolInstanceReusePolicyArgs(
        reuseOnScaleIn = reuseOnScaleIn,
    )
}
