@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property metric Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
 * @property stat Statistic of the metrics to return.
 * @property unit Unit of the metrics to return.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs(
    public val metric: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgs>,
    public val stat: Output<String>,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs.builder()
            .metric(metric.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stat(stat.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgsBuilder
internal constructor() {
    private var metric:
        Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgs>? =
        null

    private var stat: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("qnnkhqmwyxmhcqys")
    public suspend fun metric(`value`: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("wcecxlncpmkrdnqe")
    public suspend fun stat(`value`: Output<String>) {
        this.stat = value
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("owudyoichdgpkxlw")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("mmtvtbxgiaqbncmt")
    public suspend fun metric(`value`: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument Structure that defines the CloudWatch metric to return, including the metric name, namespace, and dimensions.
     */
    @JvmName("ewriarcttxvkbxdy")
    public suspend fun metric(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Statistic of the metrics to return.
     */
    @JvmName("mdsjxoknuqmlcmgs")
    public suspend fun stat(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stat = mapped
    }

    /**
     * @param value Unit of the metrics to return.
     */
    @JvmName("nrtlkvdcfkikjkfv")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedCapacityMetricSpecificationMetricDataQueryMetricStatArgs(
            metric = metric ?: throw PulumiNullFieldException("metric"),
            stat = stat ?: throw PulumiNullFieldException("stat"),
            unit = unit,
        )
}
