@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricDataQueries List of up to 10 structures that defines custom load metric in predictive scaling policy
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs(
    public val metricDataQueries: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs.builder()
            .metricDataQueries(
                metricDataQueries.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgsBuilder
internal constructor() {
    private var metricDataQueries:
        Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>>? =
        null

    /**
     * @param value List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("ludwgjilqsvwffyi")
    public suspend fun metricDataQueries(`value`: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = value
    }

    @JvmName("hqvpdfkkbtprhpvd")
    public suspend fun metricDataQueries(vararg values: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>) {
        this.metricDataQueries = Output.all(values.asList())
    }

    /**
     * @param values List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("aeixabuwvikevmga")
    public suspend fun metricDataQueries(values: List<Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = Output.all(values)
    }

    /**
     * @param value List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("xkwscivtaxuvaeef")
    public suspend fun metricDataQueries(`value`: List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("bbpqwbmrktjbfvcb")
    public suspend fun metricDataQueries(argument: List<suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("diwxtcmudfhuekvp")
    public suspend fun metricDataQueries(vararg argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("rxuewxkdrsfdamth")
    public suspend fun metricDataQueries(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param values List of up to 10 structures that defines custom load metric in predictive scaling policy
     */
    @JvmName("xnfgrcqxmvufpdfv")
    public suspend fun metricDataQueries(vararg values: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationMetricDataQueryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedLoadMetricSpecificationArgs(
            metricDataQueries = metricDataQueries ?: throw PulumiNullFieldException("metricDataQueries"),
        )
}
