@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricDataQueries List of up to 10 structures that defines custom scaling metric in predictive scaling policy
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs(
    public val metricDataQueries: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs.builder()
            .metricDataQueries(
                metricDataQueries.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgsBuilder
internal constructor() {
    private var metricDataQueries:
        Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>>? =
        null

    /**
     * @param value List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("wpgumcllqkomsjwv")
    public suspend fun metricDataQueries(`value`: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = value
    }

    @JvmName("mpeoolpfatesjjpk")
    public suspend fun metricDataQueries(vararg values: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>) {
        this.metricDataQueries = Output.all(values.asList())
    }

    /**
     * @param values List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("uqvcfoxjaxrjtegk")
    public suspend fun metricDataQueries(values: List<Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>>) {
        this.metricDataQueries = Output.all(values)
    }

    /**
     * @param value List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("olorojhvppgmuwls")
    public suspend fun metricDataQueries(`value`: List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("apvoatfcfawctvhy")
    public suspend fun metricDataQueries(argument: List<suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("mfpsmdtygdbhfnmd")
    public suspend fun metricDataQueries(vararg argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param argument List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("yfygnftnqrewlihe")
    public suspend fun metricDataQueries(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metricDataQueries = mapped
    }

    /**
     * @param values List of up to 10 structures that defines custom scaling metric in predictive scaling policy
     */
    @JvmName("vcljxilcmenlpbws")
    public suspend fun metricDataQueries(vararg values: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDataQueries = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationArgs(
            metricDataQueries = metricDataQueries ?: throw PulumiNullFieldException("metricDataQueries"),
        )
}
