@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property namespace Namespace of the metric.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs(
    public val dimensions: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>>? =
        null,
    public val metricName: Output<String>,
    public val namespace: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs.builder()
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgsBuilder
internal constructor() {
    private var dimensions:
        Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("gkfcxrqcqiuddcjs")
    public suspend fun dimensions(`value`: Output<List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>>) {
        this.dimensions = value
    }

    @JvmName("dvwtatjoqlvgdntl")
    public suspend fun dimensions(vararg values: Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>) {
        this.dimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("qgekkligrmdfvppb")
    public suspend fun dimensions(values: List<Output<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>>) {
        this.dimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("yidsfrentnspbikx")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("errigiiyrihuojoo")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("fslaumjncderahty")
    public suspend fun dimensions(`value`: List<PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("tvhsplbfyosbdari")
    public suspend fun dimensions(argument: List<suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("xoojnhsvahhyoapl")
    public suspend fun dimensions(vararg argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("ajnvsegrlkyadsbb")
    public suspend fun dimensions(argument: suspend PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.dimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("uunffxpspscfubie")
    public suspend fun dimensions(vararg values: PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("tkvdbcwwcjfcrpus")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("humefctihkhwctov")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationCustomizedScalingMetricSpecificationMetricDataQueryMetricStatMetricArgs(
            dimensions = dimensions,
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        )
}
