@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedMetricType Metric type. Valid values are `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`, or `ALBTargetGroupRequestCount`.
 * @property resourceLabel Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs(
    public val predefinedMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs.builder()
            .predefinedMetricType(predefinedMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgsBuilder
internal constructor() {
    private var predefinedMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Metric type. Valid values are `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`, or `ALBTargetGroupRequestCount`.
     */
    @JvmName("tphhxiqcflvdobae")
    public suspend fun predefinedMetricType(`value`: Output<String>) {
        this.predefinedMetricType = value
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("tobbncdlqvqcpxln")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Metric type. Valid values are `ASGTotalCPUUtilization`, `ASGTotalNetworkIn`, `ASGTotalNetworkOut`, or `ALBTargetGroupRequestCount`.
     */
    @JvmName("wbiliwopuqvqwfti")
    public suspend fun predefinedMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedMetricType = mapped
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("oqjhcgxtyysixglp")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedLoadMetricSpecificationArgs(
            predefinedMetricType = predefinedMetricType ?: throw
                PulumiNullFieldException("predefinedMetricType"),
            resourceLabel = resourceLabel,
        )
}
