@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property predefinedMetricType Which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric. Valid values are `ASGCPUUtilization`, `ASGNetworkIn`, `ASGNetworkOut`, or `ALBRequestCount`.
 * @property resourceLabel Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
 */
public data class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs(
    public val predefinedMetricType: Output<String>,
    public val resourceLabel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs.builder()
            .predefinedMetricType(predefinedMetricType.applyValue({ args0 -> args0 }))
            .resourceLabel(resourceLabel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs].
 */
@PulumiTagMarker
public class
PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgsBuilder
internal constructor() {
    private var predefinedMetricType: Output<String>? = null

    private var resourceLabel: Output<String>? = null

    /**
     * @param value Which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric. Valid values are `ASGCPUUtilization`, `ASGNetworkIn`, `ASGNetworkOut`, or `ALBRequestCount`.
     */
    @JvmName("fsxxdjapsqmpbrko")
    public suspend fun predefinedMetricType(`value`: Output<String>) {
        this.predefinedMetricType = value
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("fvifodyvorspcnug")
    public suspend fun resourceLabel(`value`: Output<String>) {
        this.resourceLabel = value
    }

    /**
     * @param value Which metrics to use. There are two different types of metrics for each metric type: one is a load metric and one is a scaling metric. For example, if the metric type is `ASGCPUUtilization`, the Auto Scaling group's total CPU metric is used as the load metric, and the average CPU metric is used for the scaling metric. Valid values are `ASGCPUUtilization`, `ASGNetworkIn`, `ASGNetworkOut`, or `ALBRequestCount`.
     */
    @JvmName("ifumbmxgdjlaausg")
    public suspend fun predefinedMetricType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.predefinedMetricType = mapped
    }

    /**
     * @param value Label that uniquely identifies a specific Application Load Balancer target group from which to determine the request count served by your Auto Scaling group. You create the resource label by appending the final portion of the load balancer ARN and the final portion of the target group ARN into a single value, separated by a forward slash (/). Refer to [PredefinedMetricSpecification](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/API_PredefinedMetricSpecification.html) for more information.
     */
    @JvmName("kfsogdssyfkuayrv")
    public suspend fun resourceLabel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLabel = mapped
    }

    internal fun build(): PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs =
        PolicyPredictiveScalingConfigurationMetricSpecificationPredefinedMetricPairSpecificationArgs(
            predefinedMetricType = predefinedMetricType ?: throw
                PulumiNullFieldException("predefinedMetricType"),
            resourceLabel = resourceLabel,
        )
}
