@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.autoscaling.kotlin.inputs

import com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricDimensions Dimensions of the metric.
 * @property metricName Name of the metric.
 * @property metrics Metrics to include, as a metric data query.
 * @property namespace Namespace of the metric.
 * @property statistic Statistic of the metric.
 * @property unit Unit of the metric.
 */
public data class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs(
    public val metricDimensions: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>? =
        null,
    public val metricName: Output<String>? = null,
    public val metrics: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>? =
        null,
    public val namespace: Output<String>? = null,
    public val statistic: Output<String>? = null,
    public val unit: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs> {
    override fun toJava(): com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs =
        com.pulumi.aws.autoscaling.inputs.PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs.builder()
            .metricDimensions(
                metricDimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metricName(metricName?.applyValue({ args0 -> args0 }))
            .metrics(
                metrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .statistic(statistic?.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs].
 */
@PulumiTagMarker
public class PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgsBuilder internal constructor() {
    private var metricDimensions:
        Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>? =
        null

    private var metricName: Output<String>? = null

    private var metrics:
        Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>? = null

    private var namespace: Output<String>? = null

    private var statistic: Output<String>? = null

    private var unit: Output<String>? = null

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("ivxwnwgljqksmxwk")
    public suspend fun metricDimensions(`value`: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>) {
        this.metricDimensions = value
    }

    @JvmName("qxfymowqyiyvdskj")
    public suspend fun metricDimensions(vararg values: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>) {
        this.metricDimensions = Output.all(values.asList())
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("catmjwirsccwochw")
    public suspend fun metricDimensions(values: List<Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>>) {
        this.metricDimensions = Output.all(values)
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("pxipwqecbdbbgoam")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("vugxyrhhrnkglcdj")
    public suspend fun metrics(`value`: Output<List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = value
    }

    @JvmName("qafgkoattxoumxvw")
    public suspend fun metrics(vararg values: Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>) {
        this.metrics = Output.all(values.asList())
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("kbxpetckmqmkbkhe")
    public suspend fun metrics(values: List<Output<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>>) {
        this.metrics = Output.all(values)
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("moyguytsvspwyiwk")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Statistic of the metric.
     */
    @JvmName("akehixhkiaysolub")
    public suspend fun statistic(`value`: Output<String>) {
        this.statistic = value
    }

    /**
     * @param value Unit of the metric.
     */
    @JvmName("gaylvatootqgogao")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value Dimensions of the metric.
     */
    @JvmName("mihwvtymnumyxwcm")
    public suspend fun metricDimensions(`value`: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("hiuqcktekcvchpdr")
    public suspend fun metricDimensions(argument: List<suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("gpgwvomqntpblrps")
    public suspend fun metricDimensions(vararg argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param argument Dimensions of the metric.
     */
    @JvmName("qsbnydrbhupaiibg")
    public suspend fun metricDimensions(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metricDimensions = mapped
    }

    /**
     * @param values Dimensions of the metric.
     */
    @JvmName("pggjnisyiivhxidl")
    public suspend fun metricDimensions(vararg values: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricDimensions = mapped
    }

    /**
     * @param value Name of the metric.
     */
    @JvmName("kubmvbyvkhwbnrgt")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value Metrics to include, as a metric data query.
     */
    @JvmName("xvmgakrjfoofvelo")
    public suspend fun metrics(`value`: List<PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("kiwoviaippssloih")
    public suspend fun metrics(argument: List<suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("wtydhhqvmjjujxtn")
    public suspend fun metrics(vararg argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param argument Metrics to include, as a metric data query.
     */
    @JvmName("hoxtdglcymohbbtj")
    public suspend fun metrics(argument: suspend PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.metrics = mapped
    }

    /**
     * @param values Metrics to include, as a metric data query.
     */
    @JvmName("gsxonhgyvxhuevyy")
    public suspend fun metrics(vararg values: PolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metrics = mapped
    }

    /**
     * @param value Namespace of the metric.
     */
    @JvmName("umoekxssvrlkmcex")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Statistic of the metric.
     */
    @JvmName("toyptgcufycbidve")
    public suspend fun statistic(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistic = mapped
    }

    /**
     * @param value Unit of the metric.
     */
    @JvmName("yiyxthrfsjgcftld")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    internal fun build(): PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs =
        PolicyTargetTrackingConfigurationCustomizedMetricSpecificationArgs(
            metricDimensions = metricDimensions,
            metricName = metricName,
            metrics = metrics,
            namespace = namespace,
            statistic = statistic,
            unit = unit,
        )
}
